#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h"
#include "Rtc_Ds1307.h"

TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7
Rtc_Ds1307 rtc(PTE0, PTE1);//SCL,SDA
QEI wheel (PTA16, PTA17, NC, 48);

DebouncedIn button_enco(PTC5);
//DebouncedIn button_confi(PTB8);
//InterruptIn button_confi(PTB8);

DigitalOut led1(PTC7);
DigitalOut led2(PTC0);
DigitalOut led3(PTC3);
DigitalOut led4(PTC4);

PwmOut Sonido(PTA5);

float periodo;
float Frecuencia=4000;
int C1=0x0C;
int m,k,x1,x2,x3,x4;
int numero=1;
int Conf=0;  // 0: Alarma y 1:Reloj
int Lugar=0; // Definen el punto en el cual va el programa
int i=0;
int visual=0;
int alarma=0; 
 

int main()
{
    Rtc_Ds1307::Time_rtc tm = {};
    Rtc_Ds1307::Time_rtc Alarm = {};
    Rtc_Ds1307::Time_rtc Alarm2 = {};
    Rtc_Ds1307::Time_rtc Alarm3 = {};
    Rtc_Ds1307::Time_rtc Alarm4 = {};
    lcd.cls();
    lcd.writeCommand(C1);//escribimos un comando segun el manual del modulo LCD
       
    periodo=(1/Frecuencia);
    Sonido.period(periodo);
    

    while(1){
        switch (Lugar){
            case 0:     //Menu principal
                rtc.getTime(tm); //lee el tiempo del DS1307 
                lcd.locate(0,0);
                lcd.printf("%02d:%02d %02d/%02d/%02d", tm.hour, tm.min, tm.date, tm.mon, tm.year);
                lcd.locate(0,1);
                lcd.printf("-C.Alar  -C.Hora");
                m=wheel.getPulses();  // m son los datos del encoder
                if(m!=0 && Conf==0){
                    Conf=1;
                    wheel.reset();  
                    m=0;              
                }
                if(m!=0 && Conf==1){
                    Conf=0;
                    wheel.reset();  
                    m=0;              
                }
                if(Conf==0){
                    lcd.locate(9,1);
                    lcd.printf("-");                    
                    lcd.locate(0,1);
                    lcd.printf(">");
                    //lcd.locate(0,1);                    
                    wait(0.1);
                }
                if(Conf==1){
                    lcd.locate(0,1);
                    lcd.printf("-");                    
                    lcd.locate(9,1);
                    lcd.printf(">");
                    //lcd.locate(0,1);                    
                    wait(0.1);
                }
                if (button_enco.falling()){  //si se pulsa boton encoder
                    Lugar++;
                    m=0;       
                }
            break;
            
            case 1://Configurar
                switch(i){
                    case 0:
                       if(Conf==0){
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Config. Alarma ");
                            wait(1);
                            goto lazo;
sigo:                       i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Dia: ");
                            tm.date=1;                             
                        }
                       if(Conf==1){
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Config. hora   ");
                            wait(1);
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Dia: ");
                        }    
                    break;
                    
                    case 1:
                        m=wheel.getPulses();        
                        if (m!=0){
                            tm.date=tm.date+m;
                            if(tm.date>31){
                                tm.date=31;
                            }
                            if(tm.date<1){
                                tm.date=1;
                            }
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(5,0);
                        lcd.printf("%02d",tm.date);
                        
                        if (button_enco.falling()){
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Mes: ");
                            //tm.mon=1;
                        }
                    break;
                    
                    case 2:
                        m=wheel.getPulses();        
                        if (m!=0){
                            tm.mon=tm.mon+m;
                            if(tm.mon>12){
                                tm.mon=12;
                            }
                            if(tm.mon<1){
                                tm.mon=1;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(5,0);
                        lcd.printf("%02d",tm.mon);
                        
                        if (button_enco.falling()){
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Year: ");
                            
                        }
                    break;
                    
                    case 3:
                        m=wheel.getPulses();        
                        if (m!=0){
                            tm.year=tm.year+m;
                            
                            if(tm.year<2016){
                                tm.year=2016;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.year);
                        
                        if (button_enco.falling()){
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Hora: ");
                            
                        }
                    break;
                    
                     case 4:
                        m=wheel.getPulses();
                        if (m!=0){
                            tm.hour=tm.hour + m;
                            if(tm.hour>23){
                                tm.hour=23;
                            }
                            if(tm.hour<0){
                                tm.hour=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(6,0);
                        lcd.printf("%02d",tm.hour);
                        
                        if (button_enco.falling()){
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Minuto: ");
                            //tm.min=0;
                        }
                    break;
                    
                    case 5:
                        m=wheel.getPulses();        
                        if (m!=0){
                            tm.min=tm.min+m;
                            if(tm.min>59){
                                tm.min=59;
                            }
                            if(tm.min<0){
                                tm.min=0;
                            }
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(8,0);
                        lcd.printf("%02d",tm.min);
                        
                        if (button_enco.falling()){
                            i++;
                            m=0;
                            lcd.cls();
                            lcd.locate(0,0);
                            lcd.printf("Segundo: ");
                            //tm.sec=0;
                        }
                    break;
                    
                    
                    case 6:
                        m=wheel.getPulses();        
                        if (m!=0){
                            tm.sec=tm.sec+m;
                            if(tm.sec>59){
                                tm.sec=59;
                            }
                            if(tm.sec<0){
                                tm.sec=0;
                            }
                            
                            wheel.reset();  
                            m=0;
                        }
                        lcd.locate(9,0);
                        lcd.printf("%02d",tm.sec);
                        
                        if (button_enco.falling()){
                            ///////////////////
                            if(Conf==0){
                                if(numero ==1){
                                    Alarm=tm;
                                    x1=1;    
                                }
                                if(numero ==2){
                                    Alarm2=tm;
                                    x2=1;    
                                }
                                if(numero ==3){
                                    Alarm3=tm;    
                                    x3=1;
                                }
                                if(numero ==4){
                                    Alarm4=tm;    
                                    x4=1;
                                }
                                lcd.cls();
                                lcd.locate(0,1);
                                lcd.printf("Alarma %02d config",numero);
                                wait(1);
                                i=0;
                                m=0;
                                Lugar++;
                                lcd.cls();
                            }
                
                            if(Conf==1){
                                rtc.setTime(tm, false, false);
                                rtc.startClock();
                                lcd.cls();
                                lcd.locate(0,0);
                                lcd.printf("Hora Config.  ");
                                wait(1);
                                i=0;
                                m=0;
                                Lugar=0;
                                rtc.getTime(tm); //lee el tiempo del DS1307 
                                lcd.locate(0,0);
                                lcd.printf("%02:",tm.hour);
                                lcd.locate(0,1);
                                lcd.printf("-C.Alar  -C.Hora");
                           } 
                        }
                    break;
                 }            
            break;
            
            case 2:     //Visualizar y Activacion Alarmas
                rtc.getTime(tm);
                m=wheel.getPulses();
                if(x1==1){
                    led1=1;
                }
                if(x2==1){
                    led2=1;
                }
                if(x3==1){
                    led3=1;
                }
                if(x4==1){
                    led4=1;
                }                
                if(m!=0){
                   visual=visual+m;
                   if(visual<0){
                      visual=0;
                   }
                   if(visual>4){
                      visual=4;
                   }                    
                   wheel.reset();  
                   m=0;
                }
                
                if(visual==0){//Visualiza hora
                   lcd.cls();
                   lcd.locate(0,0);    
                   lcd.printf(" Ver   %02d:%02d:%02d",tm.hour,tm.min,tm.sec);
                   lcd.locate(0,1);
                   lcd.printf("Hora :%02d/%02d/%04d",tm.mon,tm.date,tm.year);
                   wait(0.1);
                }   
                if(visual==1){//Visualilza alarma1
                   lcd.cls();
                   lcd.locate(0,0);    
                   lcd.printf(" Ver   %02d:%02d:%02d", Alarm.hour, Alarm.min,Alarm.sec);
                   lcd.locate(0,1);
                   lcd.printf("Alar1:%02d/%02d/%04d",Alarm.mon,Alarm.date,Alarm.year);
                   wait(0.1);
                }
                if(visual==2){//Visualiza alarma2
                   lcd.cls();
                   lcd.locate(0,0);    
                   lcd.printf(" Ver   %02d:%02d:%02d", Alarm2.hour, Alarm2.min,Alarm2.sec);
                   lcd.locate(0,1);
                   lcd.printf("Alar2:%02d/%02d/%04d",Alarm2.mon,Alarm2.date,Alarm2.year);
                   wait(0.1);
                }
                if(visual==3){//Visualiza alarma3
                   lcd.cls();
                   lcd.locate(0,0);    
                   lcd.printf(" Ver   %02d:%02d:%02d", Alarm3.hour, Alarm3.min,Alarm3.sec);
                   lcd.locate(0,1);
                   lcd.printf("Alar3:%02d/%02d/%04d",Alarm3.mon,Alarm3.date,Alarm3.year);
                   wait(0.1);
                }
                if(visual==4){//Visualiza alarma4
                   lcd.cls();
                   lcd.locate(0,0);    
                   lcd.printf(" Ver   %02d:%02d:%02d", Alarm4.hour, Alarm4.min,Alarm4.sec);
                   lcd.locate(0,1);
                   lcd.printf("Alar4:%02d/%02d/%04d",Alarm4.mon,Alarm4.date,Alarm4.year);
                   wait(0.1);
                }
                     
                if (button_enco.falling()){
                    Lugar=1;
                }
                //Activacion  Alarma1               
                if((tm.date==Alarm.date)&&(tm.mon==Alarm.mon)&&(tm.year==Alarm.year)&&(tm.hour==Alarm.hour)&&(tm.min==Alarm.min)&&(tm.sec==Alarm.sec))
                {
                    Lugar++;
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma1  Activa!!");
                    led1 =0;
                    wait(.2);
                    led1 =1;
                    wait(.2);
                    led1 =0;
                    wait(.2);
                    led1 =1;
                    wait(.2);
                    led1 =0;
                    lcd.locate(0,0);
                    lcd.printf("->Desactivar    ");                       
                    lcd.locate(0,1);                        
                    lcd.printf("--Aplazar       ");
                    m=0;
                    k=1;
                }

                //Activacion  Alarma2               
                if((tm.date==Alarm2.date)&&(tm.mon==Alarm2.mon)&&(tm.year==Alarm2.year)&&(tm.hour==Alarm2.hour)&&(tm.min==Alarm2.min)&&(tm.sec==Alarm2.sec))
                {
                    Lugar++;
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma2  Activa!!");
                    led2 =0;
                    wait(.2);
                    led2 =1;
                    wait(.2);
                    led2 =0;
                    wait(.2);
                    led2 =1;
                    wait(.2);
                    led2 =0;
                    lcd.locate(0,0);
                    lcd.printf("->Desactivar    ");                       
                    lcd.locate(0,1);                        
                    lcd.printf("--Aplazar       ");
                    m=0;
                    k=2;
                }

                //Activacion  Alarma3               
                if((tm.date==Alarm3.date)&&(tm.mon==Alarm3.mon)&&(tm.year==Alarm3.year)&&(tm.hour==Alarm3.hour)&&(tm.min==Alarm3.min)&&(tm.sec==Alarm3.sec))
                {
                    Lugar++;
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma3  Activa!!");
                    led3 =0;
                    wait(.2);
                    led3 =1;
                    wait(.2);
                    led3 =0;
                    wait(.2);
                    led3 =1;
                    wait(.2);
                    led3 =0;
                    lcd.locate(0,0);
                    lcd.printf("->Desactivar    ");                       
                    lcd.locate(0,1);                        
                    lcd.printf("--Aplazar       ");
                    m=0;
                    k=3;
                }
                //Activacion  Alarma4               
                if((tm.date==Alarm4.date)&&(tm.mon==Alarm4.mon)&&(tm.year==Alarm4.year)&&(tm.hour==Alarm4.hour)&&(tm.min==Alarm4.min)&&(tm.sec==Alarm4.sec))
                {
                    Lugar++;
                    lcd.cls();
                    lcd.locate(0,0);                        
                    lcd.printf("Alarma1  Activa!!");
                    led4 =0;
                    wait(.2);
                    led4 =1;
                    wait(.2);
                    led4 =0;
                    wait(.2);
                    led4 =1;
                    wait(.2);
                    led4 =0;
                    lcd.locate(0,0);
                    lcd.printf("->Desactivar    ");                       
                    lcd.locate(0,1);                        
                    lcd.printf("--Aplazar       ");
                    m=0;
                    k=4;
                }
                 
            break;
            
            
            
            
            case 3://Aplazar Desactivar Alarma
                
                if(alarma==0){
                    Sonido.write(0.5);
                    wait(0.2);
                    Sonido.write(0);
                    wait(0.2);
                    Sonido.write(0.5);
                    wait(0.2);
                    Sonido.write(0);
                    wait(0.2);
                    m=wheel.getPulses();
                    if(m!=0){                        
                        alarma=1;
                        m=0;
                        wheel.reset();
                        
                        lcd.locate(1,0);
                        lcd.printf("-");                    
                        lcd.locate(1,1);
                        lcd.printf(">");                                          
                    }
                }
                          
                ///////////////////
                
                if(alarma==1){
                    Sonido.write(0.5);
                    wait(0.2);
                    Sonido.write(0);
                    wait(0.2);
                    Sonido.write(0.5);
                    wait(0.2);
                    Sonido.write(0);
                    wait(0.2);
                    
                    m=wheel.getPulses();
                    if(m!=0){                        
                        alarma=0;
                        m=0;
                        wheel.reset();
                        
                        lcd.locate(1,0);
                        lcd.printf(">");                    
                        lcd.locate(1,1);
                        lcd.printf("-");                                          
                    }
                }
                
                if (button_enco.falling()){
                    if(alarma==0){
                        Lugar=0;
                        wheel.reset();
                        m=0;
                        Sonido.write(0);
                        lcd.cls();
                        rtc.getTime(tm); //lee el tiempo del DS1307 
                        lcd.locate(0,0);
                        lcd.printf("%02:",tm.hour);
                        lcd.locate(0,1);
                        lcd.printf("-C.Alar -C.Hora");
                        
                    }
                    if(alarma==1){
                        Lugar=2;
                        rtc.getTime(tm);

                        switch(k){
                            case 1:
                                if(tm.min!=58){
                                    Alarm.min=tm.min+1;
                                }
                                if(tm.min==59){
                                    Alarm.min=0;
                                    Alarm.hour=tm.hour+1;
                                }
                                Alarm.sec=tm.sec;
                                led1 =1;
                                lcd.cls();
                                alarma=0;
                            break;
                            
                            case 2:
                                if(tm.min!=58){
                                    Alarm2.min=tm.min+1;
                                }
                                if(tm.min==59){
                                    Alarm2.min=0;
                                    Alarm2.hour=tm.hour+1;
                                }
                                Alarm2.sec=tm.sec;
                                led2 =1;
                                lcd.cls();
                                alarma=0;
                            break;
                            
                            case 3:
                                if(tm.min!=58){
                                    Alarm3.min=tm.min+1;
                                }
                                if(tm.min==59){
                                    Alarm3.min=0;
                                    Alarm3.hour=tm.hour+1;
                                }
                                Alarm3.sec=tm.sec;
                                led3 =1;
                                lcd.cls();
                                alarma=0;
                            break;
                            
                            case 4:
                                if(tm.min!=58){
                                    Alarm4.min=tm.min+1;
                                }
                                if(tm.min==59){
                                    Alarm4.min=0;
                                    Alarm4.hour=tm.hour+1;
                                }
                                Alarm4.sec=tm.sec;
                                led4 =1;
                                lcd.cls();
                                alarma=0;                            
                            break;    
                        }
                    }
                    
                }
                
            
            break;
        }             
    
    }
// Lazo de Config Alarmas   
lazo:   int t=0;
        numero=1;
        while(t==0){    
            m=wheel.getPulses(); 
            lcd.locate(0,0);
            lcd.printf("Config Alarma %02d",numero);
            lcd.locate(0,1);
            lcd.printf("-1  -2   -3  -4",tm.date);
            if (m!=0){
                numero=numero+m;
                if(numero<1){
                    numero=1;
                    }
                if(numero>4){
                    numero=4;
                    }
                wheel.reset();  
                    m=0;
                    }
                if(numero==1){
                    led1 =1;
                    led2 =0;
                    led3 =0;
                    led4 =0;
                    lcd.locate(0,1);
                    lcd.printf(">");                    
                    lcd.locate(4,1);
                    lcd.printf("-");
                    lcd.locate(9,1);                    
                    lcd.printf("-");
                    lcd.locate(13,1);                    
                    lcd.printf("-");
                    wait(0.1);    
                    }
                if(numero==2){
                    led1 =0;
                    led2 =1;
                    led3 =0;
                    led4 =0;
                    lcd.locate(0,1);
                    lcd.printf("-");                    
                    lcd.locate(4,1);
                    lcd.printf(">");
                    lcd.locate(9,1);                    
                    lcd.printf("-");
                    lcd.locate(13,1);                    
                    lcd.printf("-");                  
                    wait(0.1);
                    }
                if(numero==3){         
                    led1 =0;
                    led2 =0;
                    led3 =1;
                    led4 =0;
                    lcd.locate(0,1);
                    lcd.printf("-");                    
                    lcd.locate(4,1);
                    lcd.printf("-");
                    lcd.locate(9,1);                    
                    lcd.printf(">");
                    lcd.locate(13,1);                    
                    lcd.printf("-");                  
                    wait(0.1);    
                    }
                if(numero==4){
                    led1 =0;
                    led2 =0;
                    led3 =0;
                    led4 =1;
                    lcd.locate(0,1);
                    lcd.printf("-");                    
                    lcd.locate(4,1);
                    lcd.printf("-");
                    lcd.locate(9,1);                    
                    lcd.printf("-");
                    lcd.locate(13,1);                    
                    lcd.printf(">");                  
                    wait(0.1);
                    }
                        
                if (button_enco.falling()){
                    m=0;
                    lcd.cls();
                    lcd.locate(4,0);                        
                    lcd.printf("Alarma %02d ",numero);
                    lcd.locate(2,1);                        
                    lcd.printf("Seleccionada");
                    wait(1.5);
                    lcd.cls();
                    t=1;
                    }
        }       
        goto sigo;

}   
                          
