#include "mbed.h"
#include "MQTTEthernet.h"
#include "MQTTClient.h"


// MQTT Variables
char* MqttHostname = "192.168.1.105";
int MqttPort = 1883;
char* MqttTopic = "mbed-sample-dssdsdhhuynq";
char* MqttClientId = "changeme-huynq-zcaxcaz";

int main()
{
    
    printf("Example MQTT client\r\n");

    // Brings up the network interface
    MQTTEthernet eth = MQTTEthernet();
    const char *ip = eth.get_ip_address();
    
    
    printf("IP address is: %s\r\n", ip ? ip : "No IP");
    
    // Create Mbed Client Interface
    MQTT::Client<MQTTEthernet, Countdown> client = MQTT::Client<MQTTEthernet, Countdown>(eth);

    // Create TCP connection
    eth.open(eth.getEth());
    int rc = eth.connect(MqttHostname, MqttPort);
    printf("TCP Status: %s\r\n", (rc == 0) ? "Success" : "Failure");
    
    // Wait for a short length of time to allow user to see output messages.
    Thread::wait(2000);
    
    if(rc == 0){
        
        
        printf("Starting MQTT Client");

        MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       
        data.MQTTVersion = 3;
        data.clientID.cstring = MqttClientId;
        rc = client.connect(data);
        
        
        printf("MQTT Client: %s\r\n", (rc == 0) ? "Connected" : "Failed");
        
        while(rc == 0){
            MQTT::Message message;
 
            // QoS 0
            char buf[100];
            sprintf(buf, "Hello World!");
            message.qos = MQTT::QOS0;
            message.retained = false;
            message.dup = false;
            message.payload = (void*)buf;
            message.payloadlen = strlen(buf)+1;
            rc = client.publish(MqttTopic, message);  
            
            Thread::wait(5000);

        }
    }
    
    // It is good practice to close the socket
    eth.disconnect();
}

