#include "IncEncoder.h"
#include "mbed.h"

IncEncoder::IncEncoder(PinName ENC_A,PinName ENC_B,Encoding encoding) : ENC_A_(ENC_A),ENC_B_(ENC_B){
    pulses = 0;
    
    ENC_A_.rise(this, &IncEncoder::A_RISE);
    ENC_A_.fall(this, &IncEncoder::A_FALL);
    
    if(encoding == x4_Resolution){
        ENC_B_.rise(this, &IncEncoder::B_RISE);
        ENC_B_.fall(this, &IncEncoder::B_FALL);
    }
}

int IncEncoder::GetIncPulses(){
    return pulses;
}

void IncEncoder::reset(){
    pulses = 0;
}

void IncEncoder::A_RISE(){
    if(ENC_B_) pulses++;
    else       pulses--;
}

void IncEncoder::A_FALL(){
    if(ENC_B_) pulses--;
    else       pulses++;
}

void IncEncoder::B_RISE(){
    if(ENC_A_) pulses--;
    else       pulses++;
}

void IncEncoder::B_FALL(){
    if(ENC_A_) pulses++;
    else       pulses--;
}