#include "mbed.h"
#include "NTPClient.h"
#include "EthernetInterface.h"
#include "kt_vfd.h"

// GU140X16G-7040
KT_VFD vfd(p15, p16, p17, p18, p19, p20, p21, p22, p23, p24) ;

int main()
{
    EthernetInterface eth ;

    vfd.printf("Setting up...\n") ;
    int ethError = eth.connect() ;

    if(ethError != 0) {
        vfd.printf("Connect failed (%d)", ethError) ;
        eth.disconnect() ;
        return 0 ;
    }

    NTPClient ntp(eth) ;
    vfd.cls() ;
    vfd.printf("Connect success\n", ethError) ;
    vfd.printf("IP: %s", eth.get_ip_address()) ;
    time_t ctTime ;
    wait(5) ;
    vfd.cls() ;
    while(1) {
        ntp.setTime("ntp.nict.jp") ;
        ctTime = time(NULL) + (60 * 60 * 9) ; // JST
        char buffer[64] ;
        strftime(buffer, 64, "  %a %d %b %Y\n   %H:%M:%S (JST)", localtime(&ctTime)) ;
        vfd.printf("%s\n", buffer) ;
    }
}
