#include "mbed.h"
#include "MAX30100.h"

DigitalOut led(LED1);

MAX30100 max;
uint32_t tsLastPollUs = 0;

// Tweakable parameters
// Sampling and polling frequency must be set consistently
#define POLL_PERIOD_US                      1E06 / 100
#define SAMPLING_RATE                       MAX30100_SAMPRATE_100HZ

// The LEDs currents must be set to a level that avoids clipping and maximises the
// dynamic range
#define IR_LED_CURRENT                      MAX30100_LED_CURR_50MA
#define RED_LED_CURRENT                     MAX30100_LED_CURR_27_1MA

// The pulse width of the LEDs driving determines the resolution of
// the ADC (which is a Sigma-Delta).
// set HIGHRES_MODE to true only when setting PULSE_WIDTH to MAX30100_SPC_PW_1600US_16BITS
#define PULSE_WIDTH                         MAX30100_SPC_PW_1600US_16BITS
#define HIGHRES_MODE                        true

int main() {
/*
pc.printf("POR State:\n\r");
max.printRegisters();
pc.printf("\n\r");

max.begin();
pc.printf("Begin State:\n\r");
max.printRegisters();
wait(1);
pc.printf("\n\r");

max.setMode(MAX30100_MODE_SPO2_HR);
pc.printf("\n\rSPO2 and HR Mode:\n\r");
max.printRegisters();
wait(1);

pc.printf("\n\rSetting LEDs to 50mA:\n\r");
max.setLedsCurrent(MAX30100_LED_CURR_50MA, MAX30100_LED_CURR_50MA);
max.printRegisters();
wait(10);

pc.printf("\n\rSetting LEDs to 7.6mA\n\r");
max.setLedsCurrent(MAX30100_LED_CURR_7_6MA, MAX30100_LED_CURR_7_6MA);
max.printRegisters();
pc.printf("\n\r");
return 1;
*/
max.begin();
max.setMode(MAX30100_MODE_SPO2_HR);
max.setLedsCurrent(IR_LED_CURRENT, RED_LED_CURRENT);
max.setLedsPulseWidth(PULSE_WIDTH);
max.setSamplingRate(SAMPLING_RATE);
max.setHighresModeEnabled(HIGHRES_MODE);

while(1){
if(us_ticker_read() < tsLastPollUs || us_ticker_read() - tsLastPollUs > POLL_PERIOD_US){
    max.update();
    tsLastPollUs = us_ticker_read();
    pc.printf("$%d %d;", max.rawIRValue/10, max.rawRedValue/10);
}
}
}
