#include "mbed.h"
#include "Adafruit_SSD1306.h"

#define SSD1306_ADDRESS 0x78

// an I2C sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(400000);
        start();
    };
};

uint8_t led_height = 64;
uint8_t led_width = 128;

I2CPreInit gI2C(D14,D15);
Adafruit_SSD1306_I2c gOled(gI2C,PA_8,SSD1306_ADDRESS,led_height,led_width);

DigitalOut led(LED1);

int main() {
    gOled.begin();
    gOled.clearDisplay();
    gOled.display();
    wait(0.1);
    while(1){
        led = !led;
        gOled.clearDisplay();
        gOled.drawPixel(0,0,WHITE);
        gOled.fillCircle(63, 0, 10, WHITE);
        gOled.display();
        wait(1);
        gOled.clearDisplay();
        gOled.fillCircle(63, 31, 20, WHITE);
        gOled.display();
        wait(1);
        gOled.clearDisplay();
        gOled.fillCircle(63, 63, 30, WHITE);
        gOled.display();
        wait(1);
    }
}
