#ifndef MPU6050_H
#define MPU6050_H

#include "mpu6050_reg.h"
#include "mbed.h"

enum Ascale {
  AFS_2G = 0,
  AFS_4G,
  AFS_8G,
  AFS_16G
};

enum Gscale {
  GFS_250DPS = 0,
  GFS_500DPS,
  GFS_1000DPS,
  GFS_2000DPS
};

class mpu6050 {
protected:

public:
    //wire.h functions
    void writeByte(uint8_t address, uint8_t subAddress, uint8_t data);
    char readByte(uint8_t address, uint8_t subAddress);
    void readBytes(uint8_t address, uint8_t subAddress, uint8_t count, uint8_t * dest);
    //mpu6050 functions
    void getGres();
    void getAres();
    void readAccelData(int16_t * destination);
    void readGyroData(int16_t * destination);
    int16_t readTempData();
    void lowPowerAccelOnly();
    void reset();
    void init();
    void calibrate(float * dest1, float * dest2);
    void selfTest(float * destination); // Should return percent deviation from factory trim values, +/- 14 or less deviation is a pass
    void MadgwickQuaternionUpdate(float ax, float ay, float az, float gx, float gy, float gz);
};

#endif