#include "clock.h"

Ticker counter_ticker;
Ticker toggle_ticker;

double counter = 0;
int atrial_logic = 0;
double atrial_counter = 0;
double atrial_pulse_start_time = 0;
int ventricle_logic = 0;
double ventricle_counter = 0;
double ventricle_pulse_start_time = 0;
int toggle_switch = 0;

int start_clock(void){
    counter_ticker.attach(&increment_counter, 0.0001);
    return 1;
    }

int start_toggler(double switch_time){
    toggle_ticker.attach(&toggler, switch_time);
    return 1;
    }
    
void increment_counter(void){
    counter += 0.0001;
    
    //records time at the rising edge of an atrial pulse (most recent only)
    if ((atrial_logic != 0) && (atrial_counter == 0)){
        atrial_pulse_start_time = get_time();
        }
    
    if (atrial_logic != 0){
        atrial_counter += 0.0001;
        }
    else {
        atrial_counter = 0;
        }
        
    //records time at the rising edge of a ventricle pulse (most recent only)
    if ((ventricle_logic != 0) && (ventricle_counter == 0)){
        ventricle_pulse_start_time = get_time();
        }
        
    if (ventricle_logic != 0){
        ventricle_counter += 0.0001;
        }
        
    else {
        ventricle_counter = 0;
        }
    }
    
void toggler(void){
    if(!toggle_switch){
    toggle_switch = 1;}
    else{
    toggle_switch = 0;}
    }
    
double get_time(void){
    return counter;
    }
    
int get_atrial_logic(void){
    return atrial_logic;
    }
    
int set_atrial_logic(int logic){
    atrial_logic = logic;
    return 1;
    }
    
int get_ventricle_logic(void){
    return ventricle_logic;
    }
  
int set_ventricle_logic(int logic){
    ventricle_logic = logic;
    return 1;
    } 
    
double get_ventricle_counter(void){
    return ventricle_counter;
    } 

double get_atrial_counter(void){
    return atrial_counter;
    }
