#include "mbed.h"

#define DISPLAY_RESET   D0

#define SSD1306_LCDWIDTH      128 
#define SSD1306_LCDHEIGHT      64 
#define SSD1306_SETCONTRAST   0x81 
#define SSD1306_DISPLAYALLON_RESUME 0xA4 
#define SSD1306_DISPLAYALLON 0xA5 
#define SSD1306_NORMALDISPLAY 0xA6 
#define SSD1306_INVERTDISPLAY 0xA7 
#define SSD1306_DISPLAYOFF 0xAE 
#define SSD1306_DISPLAYON 0xAF 
#define SSD1306_SETDISPLAYOFFSET 0xD3 
#define SSD1306_SETCOMPINS 0xDA 
#define SSD1306_SETVCOMDETECT 0xDB 
#define SSD1306_SETDISPLAYCLOCKDIV 0xD5 
#define SSD1306_SETPRECHARGE 0xD9 
#define SSD1306_SETMULTIPLEX 0xA8 
#define SSD1306_SETLOWCOLUMN 0x00 
#define SSD1306_SETHIGHCOLUMN 0x10 
#define SSD1306_SETSTARTLINE 0x40 
#define SSD1306_MEMORYMODE 0x20 
#define SSD1306_COLUMNADDR 0x21 
#define SSD1306_PAGEADDR   0x22 
#define SSD1306_COMSCANINC 0xC0 
#define SSD1306_COMSCANDEC 0xC8 
#define SSD1306_SEGREMAP 0xA0 
#define SSD1306_CHARGEPUMP 0x8D 
#define SSD1306_EXTERNALVCC 0x1 
#define SSD1306_SWITCHCAPVCC 0x2

 I2C i2c(I2C_SDA, I2C_SCL);

char _i2c_address; 
char display_buffer[1024];

void ssd1306_command(char c){
    char control = 0x00;
    i2c.start();
    i2c.write(_i2c_address);
    i2c.write(control);
    i2c.write(c);
    i2c.stop();   
}

void ssd1306_data(char c){
    i2c.start();
    i2c.write(_i2c_address);
    i2c.write(0x40);
    i2c.write(c);
    i2c.stop();
}

void setColAddress() 
{ 
  ssd1306_command(SSD1306_COLUMNADDR); // 0x21 COMMAND 
  ssd1306_command(0); // Column start address 
  ssd1306_command(SSD1306_LCDWIDTH-1); // Column end address 
} 

void setPageAddress() 
{ 
  ssd1306_command(SSD1306_PAGEADDR); // 0x22 COMMAND 
  ssd1306_command(0); // Start Page address 
  ssd1306_command((SSD1306_LCDHEIGHT/8)-1);// End Page address 
} 

void TransferBuffer() 
{ 
  int j=0; 
  
      // set the Column and Page addresses to 0,0 
      setColAddress(); 
      setPageAddress(); 
        
      i2c.start(); 
      i2c.write(_i2c_address); 
      i2c.write(0X40); // data not command 
      for(j=0;j<1024;j++) 
      { 
        i2c.write(display_buffer[j]); 
      } 

      i2c.stop(); 
} 

void InitializeDisplay()
{
    DigitalOut(DISPLAY_RESET,1);
    // VDD (3.3V) goes high at start, lets just chill for a ms
    wait_ms(1);
    // bring reset low
    DigitalOut(DISPLAY_RESET,0);
    // wait 10ms
    wait_ms(10);
    // bring out of reset
    DigitalOut(DISPLAY_RESET,1);
    // turn on VCC (9V?)

// Init sequence for 128x64 OLED module 
    ssd1306_command(SSD1306_DISPLAYOFF);                    // 0xAE 

    ssd1306_command(SSD1306_SETDISPLAYCLOCKDIV);            // 0xD5 
    ssd1306_command(0x80);                 // the suggested ratio 0x80 
    
    ssd1306_command(SSD1306_SETMULTIPLEX);                  // 0xA8 
    ssd1306_command(0x3F); 
    
    ssd1306_command(SSD1306_SETDISPLAYOFFSET);              // 0xD3 
    ssd1306_command(0x0);                                   // no offset 
    
    ssd1306_command(SSD1306_SETSTARTLINE);// | 0x0);        // line #0 
    
    ssd1306_command(SSD1306_CHARGEPUMP);                    // 0x8D 
    ssd1306_command(0x14);  // using internal VCC 
    
    ssd1306_command(SSD1306_MEMORYMODE);                    // 0x20 
    ssd1306_command(0x00);          // 0x00 horizontal addressing 
    
    ssd1306_command(SSD1306_SEGREMAP | 0x1); // rotate screen 180 
    
    ssd1306_command(SSD1306_COMSCANDEC); // rotate screen 180 
    
    ssd1306_command(SSD1306_SETCOMPINS);                    // 0xDA 
    ssd1306_command(0x12); 
    
    ssd1306_command(SSD1306_SETCONTRAST);                   // 0x81 
    ssd1306_command(0xCF); 
    
    ssd1306_command(SSD1306_SETPRECHARGE);                  // 0xd9 
    ssd1306_command(0xF1); 
    
    ssd1306_command(SSD1306_SETVCOMDETECT);                 // 0xDB 
    ssd1306_command(0x40); 
    
    ssd1306_command(SSD1306_DISPLAYALLON_RESUME);           // 0xA4 
    
    ssd1306_command(SSD1306_NORMALDISPLAY);                 // 0xA6 
  
    ssd1306_command(SSD1306_DISPLAYON);                     //switch on OLED
}

int main() {
    
    // fill buffer with something for test 
    memset( display_buffer, 0X02, 1024); // tried other values
    
    _i2c_address = 0x78;
    
    InitializeDisplay();
    
    TransferBuffer(); // try sending buffer 
    
    while(1) 
   { 
     wait_ms(1000); // keyboard code here 
     if(DigitalIn(LED1) == 0){DigitalOut(LED1,1);}
     else{DigitalOut(LED1,0);}
   } 
}
