#include "mbed.h"
#include "DFPlayerMini.h"

DigitalOut myled(LED1); //LED
DigitalIn sw(dp1);  //再生ボタン

DFPlayerMini mp3(dp16, dp15);
DigitalIn busy(dp17);   //DFPlayerMiniのBUSYと接続する

int main() {
    mp3.mp3_set_volume(30); //再生音量を設定する30が最大

    while(1)
    {
        if( sw == 1 )
        {
            myled = 1;  //LED点灯
            mp3.mp3_play(0001); //0001.mp3を再生
            wait(0.1);
            
            //再生が終わるまで待つ
            while( busy == 0 )
            {
                wait(0.1);
            }
        }
        
        //LEDを点滅させる
        myled = !myled;
        wait(0.2);
    }
}
