/*
 SDカードのtest.bmpファイルをY-CONに表示できるかもしれないプログラム
 (Y-CONで動作するかは未確認)
 
 配線
 SDカードのMISO　LPC1114の1番ピン
 SDカードのMOSI　LPC1114の2番ピン
 SDカードのCS　LPC1114の4番ピン
 SDカードのSCK　LPC1114の6番ピン
 SDカードの3V3  ブレッドボードの電源
 SDカードのGND ブレッドボードのGND

 Y-CONのVCC  ブレッドボードの電源
 Y-CONのGND  ブレッドボードのGND
 Y-CONのRX  LPC1114の16番ピン
 
 this program is public domain
 
 詳しくは
 http://kohacraft.com/archives/1069009295.html 
 
 kohacraft.com
 
*/

#include "mbed.h"
#include "SDFileSystem.h"
 
//SDFileSystem name(mosi, miso, sck, cs, mount);
SDFileSystem sd( dp2, dp1, dp6, dp4, "sd");
Serial ycon(USBTX, USBRX);

int main() {
    ycon.baud(115200); //通信速度をY-CONのビットレートに設定する
    
    FILE *fp = fopen("/sd/test.bmp", "r"); //ファイルを開く
    if(fp != NULL) {
        int data;
        while (1){  //ループ
           data = fgetc(fp); //1バイト読み込む
           if( data == EOF )   //ファイルの終わりかチェック
                break;      //ファイルの終わりならばループを抜ける
           ycon.putc((unsigned char)data);    //シリアルに送信
      }
    }
    fclose(fp); //ファイルを閉じる
    free(fp);   //解放
}