#include "mbed.h"
#include <string.h>

Serial wifi(dp16, dp15); // ESP-WROOM-02 tx, rx 
DigitalOut wifiRst(dp17); // /ESP-WROOM-02 RESET
DigitalIn lightSensor(dp4); //loom light sensor(CdS:GL5528 conect to dp4 and GND)

PwmOut sunny(dp1);    //dp1を晴れのLEDのPWM出力にします
PwmOut rainy(dp2);  //dp2を雨のLEDのPWM出力にします
PwmOut cloudy(dp18);  //dp18を曇りのLEDのPWM出力にします
PwmOut snowy(dp24);  //dp18を雪のLEDのPWM出力にします

#define baudrate 115200

static char rxbuff[1500];   //取得する文字列
int buffAdr = 0;

const char SSID[] = "your SSDI";  //アクセスポイントのSSID
const char PASS[] = "password";    //アクセスポイントのパスワード
const char WOEID[] = "28413961";    //天気を調べる場所 http://woeid.rosselliot.co.nz/ で郵便番号で検索して得られる番号

//データを受信する
bool recvData()
{
    bool ret = false;
    buffAdr = 0;
    for( int i =0 ; i< sizeof( rxbuff ) ; i++ )
        rxbuff[i] = '\0';
        
     int headerCount = 0;
     
    //1000000回ループしたらタイムアウトする
    for( int i = 0; i < 1000000 ; i++ )
    {
        if( wifi.readable() != 0 )
        {
            rxbuff[buffAdr++] = wifi.getc(); //Serial.getc()
            headerCount++;
            if( headerCount <= 1500 )   //最初の2400文字捨てる
                buffAdr=0;
            if( buffAdr >= sizeof(rxbuff)-1 )   //バッファ溢れしたら終了
            {
                ret = true;
                i=1000000;  //loopを早く終わらすために
                break;
            }

        }
    }
    
    //文字列の最後を終端
    rxbuff[sizeof(rxbuff)-1] = '\0';
    return ret;
} 

//文字列から予報天気を抽出
bool getWeather( char* str , int* weatherCord , int* tempLow , int* tempHi )
{
        //文字列探索
    char *forecast;
    if ( (forecast = strstr(str, "yweather:forecast") ) == NULL )
    {
        //取得できず
        weatherCord = 0;
        tempLow = 0;
        tempLow = 0;
        return false;
    }
    
    //天気コードを抽出
    char *codeStart,*codeEnd;
    //int weatherCord;
    codeStart = strstr(forecast, "code=");
    codeStart = strchr( codeStart , '\"' );
    codeStart++; //"の次の文字のポインタ
    codeEnd = strchr( codeStart , '\"' );
    *codeEnd = '\0';
    *weatherCord =  atoi( codeStart );    //最高気温を数字に変換
    
    //最高気温を抽出
    char *hiStart,*hiEnd;
    //int tempHi;
    hiStart = strstr(codeEnd+1, "high=");
    hiStart = strchr( hiStart , '\"' );
    hiStart++; //"の次の文字のポインタ
    hiEnd = strchr( hiStart , '\"' );
    *hiEnd = '\0';
    *tempHi =  atoi( hiStart );    //最高気温を数字に変換

    //最低気温を抽出
    char *lowStart,*lowEnd;
    //int tempLow;
    lowStart = strstr(hiEnd+1, "low=");
    lowStart = strchr( lowStart , '\"' );
    lowStart++; //"の次の文字のポインタ
    lowEnd = strchr( lowStart , '\"' );
    *lowEnd = '\0';
    *tempLow =  atoi( lowStart );    //最低気温を数字に変換
  
    //天気を抽出
    char *textStart,*textEnd;
    char weatherText[32];
    textStart = strstr(lowEnd+1, "text=");
    textStart = strchr( textStart , '\"' );
    textStart++; //"の次の文字のポインタ
    textEnd = strchr( textStart , '\"' );
    *textEnd = '\0';
    strncpy( weatherText, textStart , 32);
    
    return true;
}

//LEDを順番に光らせる
void ledIlluminationWait()
{
    snowy = 0.0;
    sunny = 1.0;
    wait(0.5);
    
    sunny = 0.0;
    rainy = 1.0;
    wait(0.5);
    
    rainy = 0.0;
    cloudy = 1.0;
    wait(0.5);
    
    cloudy = 0.0;
    snowy = 1.0;
    wait(0.5);

}

//天気に応じた明るさの変換
float wheatherIllumination( float inValue1 , float inValue2)
{
    float temp;
    
    //1に近い場合は1を返す
    if( inValue1 > 0.99 )
    {
        temp = inValue1 -inValue2*0.3;     //少し暗くする   
        return temp;
    }

    //0に近い場合は0を返す
    if( inValue1 < 0.01 )
        return 0.0;
    
    //それら以外
    temp = inValue2 * inValue1;
    return temp;    
} 

int main() {

    //LEDのPWM周期
    sunny.period(5);
    rainy.period(5);
    cloudy.period(5);
    snowy.period(5);
 
    //天気情報 1:ほとんど ～0.5:ときどき ～0:なし
    float sun = 0;
    float rain = 0;
    float cloud = 0;
    float snow = 0;
    
    lightSensor.mode(PullUp);  //室内の明るさセンサをプルアップする
    wifi.baud(baudrate);    //ビットレートを設定

    while(1)
    {
        //無線LANモジュールをリセット
        wifiRst = 1;
        wifiRst = 0;
        wifiRst = 1;
        
        //無線LANモジュールが安定するのを待つ
        for( int i=0 ; i<5 ; i++ )
        {
            ledIlluminationWait();
        }
        
        //最初にlanモジュールから出力される文字列を捨てる
        char temp;
        while( wifi.readable() == 1 )
             temp = wifi.getc();
        
        //ATコマンドで無線LANモジュールをクライアントモードにする
        wifi.printf("AT\r\n");    
        ledIlluminationWait();

        wifi.printf("AT+CWMODE=1\r\n");
        ledIlluminationWait();

        //アクセスポイントに接続
        wifi.printf("AT+CWJAP=\"%s\",\"%s\"\r\n",SSID,PASS);
        ledIlluminationWait();
        ledIlluminationWait();
        ledIlluminationWait();    
    
        while(1)
        {
            //サーバに接続
            wifi.printf("AT+CIPSTART=\"TCP\",\"query.yahooapis.com\",80\r\n");
            ledIlluminationWait();
         
            //サーバに要求
            char str[200];
            sprintf(str , "GET http://query.yahooapis.com/v1/public/yql?q=SELECT%%20*%%20FROM%%20weather.forecast%%20WHERE%%20woeid%%3D%%22%s%%22%20and%%20u%%3D%%22c%%22\r\nHost: query.yahooapis.com\r\nConnection: close\r\n\r\n\r\n",WOEID);
            wifi.printf("AT+CIPSEND=%d\r\n",strlen(str));
            ledIlluminationWait();
        
            //サーバに要求
            wifi.printf("%s",str);
            recvData(); //データの受信                
            
            //切断
            wifi.printf("AT+CIPCLOSE\r\n");
            wifi.printf("%s\r\n",rxbuff);   //バッファの内容を出力
        
            //文字列探索
            int weatherCord , tempHi , tempLow;
            if( getWeather( rxbuff , &weatherCord , &tempLow , &tempHi ) == false ) //データの受信
            {
                //予報の文字列がない
                wifi.printf("Can not find strng:forecast\r\n");
                break;  //最初からやり直す
            }
            wifi.printf("weatherCord:%d tempLow:%d tempHi:%d\r\n",weatherCord , tempLow , tempHi);
        
       
            //天気をLEDの色に変換する
            switch(weatherCord)
            {
                //晴れ
                case 24:
                case 25:
                case 31:
                case 32:
                case 36:
                    sun = 1;
                    rain = 0;
                    cloud = 0;
                    snow = 0;                
                    break;
                
                //晴れ時々曇り
                case 29:
                case 30:
                case 33:
                case 34:
                case 44:
                    sun = 1;
                    rain = 0;
                    cloud = 0.5;
                    snow = 0;                
                    break;
                
                //晴れ時々雨
                case 45:
                case 47:
                    sun = 1;
                    rain = 0.5;
                    cloud = 0;
                    snow = 0;                
                    break;
                
                //晴れ時々雪
                case 46:
                    sun = 1;
                    rain = 0;
                    cloud = 0;
                    snow = 0.5;                
                    break;
                
                
                //曇り
                case 19:
                case 21:
                case 22:
                case 26:
                    sun = 0;
                    rain = 0;
                    cloud = 1;
                    snow = 0;                
                    break;
                
                //曇り時々晴れ
                case 27:
                case 28:
                    sun = 0.5;
                    rain = 0;
                    cloud = 1;
                    snow = 0;                
                    break;
                
                //曇り時々雨
                case 9:
                case 11:
                case 20:
                case 37:
                    sun = 0;
                    rain = 0.5;
                    cloud = 1;
                    snow = 0;                
                    break;
                
                //曇り時々雪
                case 8:
                case 13:
                    sun = 0;
                    rain = 0;
                    cloud = 1;
                    snow = 0.5;                
                    break;
                              

                //雨
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 6:
                case 12:
                case 17:
                case 23:
                case 38:
                case 39:
                case 40:
                    sun = 0;
                    rain = 1;
                    cloud = 0;
                    snow = 0;                
                    break;
                                
                //雨時々雪
                case 5:
                case 10:
                case 18:
                case 35:
                    sun = 0;
                    rain = 1;
                    cloud = 0;
                    snow = 0.5;                
                    break;


                //雪
                case 14:
                case 15:
                case 16:
                case 41:
                case 42:
                case 43:
                    sun = 0;
                    rain = 0;
                    cloud = 0;
                    snow = 1;                
                    break;
                                
                //雪時々雨
                case 7:
                    sun = 0;
                    rain = 0.5;
                    cloud = 0;
                    snow = 1;                
                    break;

                
            }
                    
            for(int j=0 ; j<30*10 ; j++)  //30分ループし続ける
            {
                //3秒かけて徐々に明るくする
                for( float i = 0.0 ; i< 1.0 ; i+=0.01 )
                {
                    sunny = wheatherIllumination( sun , i );
                    rainy = wheatherIllumination( rain , i );
                    cloudy = wheatherIllumination( cloud , i );
                    snowy = wheatherIllumination( snow , i );
                    wait(0.03);
                }
                //3秒かけて徐々に暗くする
                for( float i = 1.0 ; i> 0.0 ; i-=0.01 )
                {
                    sunny = wheatherIllumination( sun , i );
                    rainy = wheatherIllumination( rain , i );
                    cloudy = wheatherIllumination( cloud , i );
                    snowy = wheatherIllumination( snow , i );
                    wait(0.03);
                }
            }
        }
    }
}
