#include "mbed.h"
#include "DFPlayerMini.h"

DigitalOut myled(LED1); //LED
DigitalIn sw(dp1);  //再生ボタン

DFPlayerMini mp3(dp16, dp15);
DigitalIn busy(dp17);   //DFPlayerMiniのBUSYと接続する

int main() {
    mp3.mp3_set_volume(30); //再生音量を設定する30が最大

    int old_sw = sw;
    while(1)
    {
        //スイッチが押されたら再生開始
        if( old_sw == 0 && sw == 1 )
        {
            myled = 1;  //LED点灯
            mp3.mp3_stop(); //現在再生されている音声を停止
            wait(0.1); 
            mp3.mp3_single_play(0001);  //0001.mp3(発車ベル)をループ再生
            wait(0.1); 
            old_sw = 1;    //スイッチの状態を保存
        }
        
        //スイッチが離されたら音を止めて次の音を再生
        if( old_sw == 1 && sw == 0 )
        {
            mp3.mp3_stop(); //現在再生されている音声を停止
            wait(0.1); 
            mp3.mp3_play(0002); //0002.mp3(発車のアナウンス)を再生  
            wait(0.1); 
            old_sw = 0;    //スイッチの状態を保存
        }
        
        //LEDを点滅させる
        myled = !myled;
        wait(0.2);
    }
}
