//はじめての手作りマイコンロボット実験セットのプログラムです
#include "mbed.h"

PwmOut ude1(dp1);   //右の腕のサーボモータ制御に使います
PwmOut ude2(dp2);   //左の腕のサーボモータ制御に使います

DigitalOut asi1(dp18);  //右のモーターを動かすのに使います
DigitalOut asi2(dp24);  //左のモーターを動かすのに使います

DigitalOut sp(dp4); //モーター動作中の時にONになります


DigitalIn mae(dp10);    //両方のモータを回すためのスイッチをつなぎます
DigitalIn hidari(dp11); //左のモータを回すためのスイッチをつなぎます
DigitalIn migi(dp9);    //右のモータを回すためのスイッチをつなぎます

DigitalOut me1(dp13);   //まばたきする目のLEDをつなぎます
DigitalOut me2(dp14);   //まばたきする目のLEDをつなぎます


//タイマー割り込みでうでをふる
//sin関数を使い振り子のようになめらかに行ったり来たりするようサーボモーターを動かします
Ticker udehuriTimer;
float kakudo=0.0;
void udehuri() {
    kakudo += 360/100;  //タイマー割り込みが実行されるごとにsin関数の角度を360/100度ずつ増やします
                        //100の部分を50などに減らすと腕の振りが速くなり、200などに増やすと振りが遅くなります
    if( kakudo > 360 ) //最大角度を超えたら0度に戻す
        kakudo = 0.0;
    float ude;
    ude = ( sin( kakudo *2*3.14/360 ) + 1.0 )/1.5 + 1.0; //1から2くらいになる
        //sin( kakudo *2*3.14/360 )+1.0 は0→2→0→2と0～2の範囲でなめらなに行ったり来たりする式です
        //その値を1.5で割るので0～1.3の範囲で変化し、最後に1.0を足すので1.0～2.3の範囲の値になります。 
        //サーボモーターに設定できる値は0.5～2.5の範囲内です。この時サーボの角度は約180度動きます
        //上記のプログラムでは約半分の100度程度腕を振ります
        //ude = ( sin( kakudo *2*3.14/360 ) + 1.0 )/1.0 + 0.5;
        //とすると0.5～2.5の範囲になり、腕が最大の振り幅の180度になります
    ude = ude / 20.0; //サーボのPWMの幅の比率に変換します
    
    ude1 = ude;
    ude2 = ude;
}

//タイマー割り込みでまばたきさせる
Ticker blink;
void mabataki(){
        me1 = 0;    //目のLEDをOFFします
        me2 = 0;
        wait(0.05); //0.05秒待って
        me1 = 1;    //目のLEDをONします
        me2 = 1;
}

int main() {
     
    
    asi1 = 0;
    asi2 = 0;
    ude1.period_ms(20); //サーボモーターの制御信号の周期が20msなのでその設定をします
    ude2.period_ms(20);    
    ude1 = 1.5/20.0;    //腕を真ん中の角度にします
    ude2 = 1.5/20.0;
    
    me1 = 1;
    me2 = 1;
    blink.attach(&mabataki, 4.0);   //4秒ごとにまばたきのプログラムが実行されるようタイマー割り込みをセットします
    while(1)
    {
        //前ボタンでで両方の足が回る
        if( mae == 1 )
        {
            sp = 1;
            udehuriTimer.attach(&udehuri, 0.02);//0.02秒ごとに腕振りのプログラムが実行されるようタイマー割り込みをセットします
            asi1 = 1;   //右のモーターを回転させます
            asi2 = 1;   //左のモーターを回転させます
            wait(0.1);  //0.1秒モータを回転させたまま待ちます
            udehuriTimer.detach();  //腕振りのタイマー割り込みを終了させます
            asi1 = 0;   //右のモーターを停止させます
            asi2 = 0;   //左のモーターを停止させます
        }
        
        //右ボタンで右のモーターが回る
        if( migi == 1 )
        {
            sp = 1;
            udehuriTimer.attach(&udehuri, 0.02);
            asi1 = 1;   //右のモーターを回転させます
            wait(0.1);
            udehuriTimer.detach();
            asi1 = 0;   //右のモーターを停止させます
        }
          
        //左ボタンで左のモーターが回る
        if( hidari == 1 )
        {
            sp = 1;
            udehuriTimer.attach(&udehuri, 0.02);
            asi2 = 1;   //左のモーターを回転させます
            wait(0.1);
            udehuriTimer.detach();
            asi2 = 0;   //左のモーターを停止させます
        }
        
        //全てのボタンを押してなければ音楽を止める
        if( mae == 0 && migi == 0 && hidari == 0)
        {
            sp = 0;
        }            
            
    }
     

}
