#include "mbed.h"
#include "font.h"
#include "ds3231.h"
#include "TLC5940.h"
int num_ics = 1;    //何個TLC5940がつながっているか

DigitalOut col1 = dp11;
DigitalOut col2 = dp13;
DigitalOut col3 = dp14;
DigitalOut col4 = dp15;
DigitalOut col5 = dp16;
DigitalOut col6 = dp17;
DigitalOut col7 = dp18;
DigitalOut col8 = dp26;

InterruptIn secInt(dp1);  //ピンの変化検出  

DigitalIn fastSw = dp28;
DigitalIn slowSw = dp25;
#define brightMax 4095

Ds3231 rtc( dp5 , dp27 ); //リアルタイムクロック
int sec = 0;
int min = 0;//
int hour =1;//
bool minChange = 0;//
bool hourChange = 0;//
bool swChange = 0;//スイッチが押された

//時間の数字をドッドの数字に変換
unsigned char hourDecfont( int num , int colm )
{
    unsigned char fontTemp = 0;
    unsigned char fontTemp2 = 0;
    int numTemp = 0 ;
    numTemp = num / 10;
    if( numTemp >0 )
    {
        fontTemp = numFont[ numTemp ][ colm ];
        fontTemp = fontTemp << 5;
    }
    numTemp = num - numTemp*10;
    fontTemp2 = numFont[ numTemp ][ colm ];
    fontTemp2 = fontTemp2 << 2;
    fontTemp = fontTemp | fontTemp2 | numFont[ 10 ][ colm ];
    
    return fontTemp;
}

//数字をドッドの数字に変換
unsigned char decfont( int num , int colm )
{
    unsigned char fontTemp = 0;
    int numTemp = 0 ;
    numTemp = num / 10;
    fontTemp = numFont[ numTemp ][ colm ];
    fontTemp = fontTemp << 4;
    numTemp = num - numTemp*10;
    fontTemp = fontTemp | numFont[ numTemp ][ colm ];
    
    return fontTemp;
}
  
//指定したフォントの、それぞれの行のピンをONOFFする
void fontOut( unsigned char font )
{
    unsigned char mask = 0x01;
    unsigned char temp = font;
    if( ( temp & mask ) !=0 )
        col1 = 1;
    else
        col1 = 0;
    mask = mask << 1;

    if( ( temp & mask ) !=0 )
        col2 = 1;
    else
        col2 = 0;
    mask = mask << 1;

    if( ( temp & mask ) !=0 )
        col3 = 1;
    else
        col3 = 0;
    mask = mask << 1;

    if( ( temp & mask ) !=0 )
        col4 = 1;
    else
        col4 = 0;
    mask = mask << 1;

    if( ( temp & mask ) !=0 )
        col5 = 1;
    else
        col5 = 0;
    mask = mask << 1;

    if( ( temp & mask ) !=0 )
        col6 = 1;
    else
        col6 = 0;
    mask = mask << 1;

    if( ( temp & mask ) !=0 )
        col7 = 1;
    else
        col7 = 0;
    mask = mask << 1;

    if( ( temp & mask ) !=0 )
        col8 = 1;
    else
        col8 = 0;
}

//1秒のカウントアップ
void secUp()
{
    sec++;        
}

void changeClock()
{
    
    if( sec >= 60 )
    {
        sec = 0;
        min++;
        minChange = 1;
    }
    if( min >= 60 )
    {
        min = 0;
        hour++;
        hourChange = 1;
    }
    if( hour >= 12 )
    {
        hour = 0;
        hourChange = 1;
    }
    
    
    //RTCに現在の時間を記録
    if( swChange != 0 )
    {
        ds3231_time_t rtc_time;
        rtc_time.hours = hour;
        rtc_time.minutes = min;
        rtc_time.seconds = sec;
        rtc_time.mode = 1; //12時間モード    
        secInt.disable_irq();   //割り込み禁止
        int value = rtc.set_time( rtc_time );   //書き込み
        secInt.enable_irq();    //割り込み許可
    }
    minChange = 0;
    hourChange = 0;
    swChange = 0;
}

int main() {
    
    
    //フォント初期化
    initFont();
    
    //TLC5940初期設定
    setup ( num_ics );
    
   
    //DS3231初期設定
    ds3231_cntl_stat_t data = {0,0}; //SQWに1秒のクロックを出力する
    rtc.set_cntl_stat_reg( data );

    secInt.rise( &secUp ); //RTCの1秒クロックでカウントアップする
    
    //DS3231に記録されている時間を読み出す
    ds3231_time_t time;
    rtc.get_time(&time);
    hour = time.hours;
    if( hour > 12 )
        hour -=12;
    min = time.minutes;
    sec = time.seconds;
   
   //スイッチの初期化
   fastSw.mode(PullDown);
   slowSw.mode(PullDown);

   
    unsigned short LEDS[16];
    
    while(1) {

        //スイッチが押されていないか
        if( slowSw == 1 )
        {
            sec++;
            swChange = 1;
        }
        if( fastSw == 1 )
        {
            min++;
            swChange = 1;
        }
        changeClock();
            
        //16行分ダイナミック点灯させる
        for( int colmn=0 ; colmn<16 ; colmn++ )
        {
            for( int h=0; h<16 ; h++ )
                LEDS[h] = 0;
            LEDS[colmn] = (unsigned short)brightMax;
            if( colmn<8 )
                fontOut( decfont( min , colmn ) );
            else
                fontOut( hourDecfont( hour , colmn-8 ) );
            
            update_led ( LEDS);
          
        }
        
    }
}
