#include "TLC5940.h"

SPI driver( dp2 , NC , dp6 );  //mosi , miso , sck
DigitalOut vprg = dp4;
DigitalOut xlat = dp9;
DigitalOut blank = dp10;
//gsclk dp24に接続(CPUクロックの2分周したクロックを利用)
int num_drivers = 1;

void setup (int num_ics)
{
    blank = 1;  //LEDをOFF
    
    //IO0_1(dp24)をCLKOUTに設定し、gsclkとして利用する
    LPC_IOCON->PIO0_1 |= 1;        // PIO0_1をCLKOUTとして使用する
    LPC_SYSCON->CLKOUTCLKSEL |= 0x3;    // 0:RC 1:Xtal 2:WDT 3:mainclock
    LPC_SYSCON->CLKOUTUEN = 0;          // レジスタ更新
    LPC_SYSCON->CLKOUTUEN = 1;
    while (!(LPC_SYSCON->CLKOUTUEN & 0x01));
    LPC_SYSCON->CLKOUTDIV |= 2;         // 2分周

    
    driver.format (6,0);
    driver.frequency (20000000);
    if (num_ics <= 0)
    {
        num_drivers = 1;
    }
    else
    {
        num_drivers = num_ics;
    }

    xlat = 0;               // hold GS/DC data constant
    
    //補正データを最大に設定
    vprg = 1;
    for (int i = 0; i<16*num_ics; i++)
    {
        driver.write (0x3F);   //最大
    }
    xlat = 1;
    xlat = 0;               // hold GS/DC data constant
    
    driver.format (12,0);
    vprg = 0;               // sets drivers to GS mode. Set to 1 to change to DC mode
    
    blank = 0;
 

}


void update_led (unsigned short* LEDS)
{
    //blank = 0;
    for (int k = (num_drivers - 1); k >= 0; k--)
    {
        for (int i = (16 - 1); i >= 0; i--)
        {
            driver.write (*(LEDS + k + i));
        }
    }
    blank = 1;
    xlat = 1;
    xlat = 0;
    blank = 0;
    
    driver.format (1,0);
    driver.write (0);
    driver.format (12,0);
    wait_us(170);  //4096階調のために必要な時間  4096/24MHz

}