#include "mbed.h"
#include "TLC5940.h"
SPI driver( dp2 , dp1 , dp6 );  //mosi , miso , sck
DigitalOut vprg = dp4;
DigitalOut xlat = dp9;
DigitalOut blank = dp10;
PwmOut gsclk = dp1;
int num_ics = 1;    //何個5940がつながっているか

#include "font.h"

DigitalOut col1 = dp11;
DigitalOut col2 = dp13;
DigitalOut col3 = dp14;
DigitalOut col4 = dp15;
DigitalOut col5 = dp16;
DigitalOut col6 = dp17;
DigitalOut col7 = dp18;
DigitalOut col8 = dp26;

DigitalIn fastSw = dp28;
DigitalIn slowSw = dp25;

#define dispTime 10
#define fastCount 500
#define slowCount 50
#define brightChange 1
#define brightMax 2024

int brightCangeValue;

Ticker secTick;

int min;//
int hour =1;//
unsigned short LEDS[16];

//時間の数字をドッドの数字に変換
unsigned char hourDecfont( int num , int colm )
{
    unsigned char fontTemp = 0;
    unsigned char fontTemp2 = 0;
    int numTemp = 0 ;
    numTemp = num / 10;
    if( numTemp >0 )
    {
        fontTemp = font[ numTemp ][ colm ];
        fontTemp = fontTemp << 5;
    }
    numTemp = num - numTemp*10;
    fontTemp2 = font[ numTemp ][ colm ];
    fontTemp2 = fontTemp2 << 2;
    fontTemp = fontTemp | fontTemp2 | font[ 10 ][ colm ];
    
    return fontTemp;
}

//数字をドッドの数字に変換
unsigned char decfont( int num , int colm )
{
    unsigned char fontTemp = 0;
    int numTemp = 0 ;
    numTemp = num / 10;
    fontTemp = font[ numTemp ][ colm ];
    fontTemp = fontTemp << 4;
    numTemp = num - numTemp*10;
    fontTemp = fontTemp | font[ numTemp ][ colm ];
    
    return fontTemp;
}
  

void fontOut( unsigned char font )
{
    unsigned char mask = 0x01;
    unsigned char temp = font;
    col1 = ( temp & mask );
    mask = mask << 1;
    col2 = ( temp & mask );
    mask = mask << 1;
    col3 = ( temp & mask );
    mask = mask << 1;
    col4 = ( temp & mask );
    mask = mask << 1;
    col5 = ( temp & mask );
    mask = mask << 1;
    col6 = ( temp & mask );
    mask = mask << 1;
    col7 = ( temp & mask );
    mask = mask << 1;
    col8 = ( temp & mask );
}

//カウントアップ
void minUp()
{
    for( int bright = brightMax ; bright > 0; bright-=brightCangeValue )
    { 
        for( int colmn=0 ; colmn<16 ; colmn++ )
        {
            brightCangeValue = brightChange;
            if( fastSw == 1 )
            {
                brightCangeValue = fastCount;
                secTick.detach();
                secTick.attach(&minUp, 60.0);   //スイッチが押されている間は自動で進まないようにTickをリセット
            }
            if( slowSw == 1 )
            {
                brightCangeValue = slowCount;
                secTick.detach();
                secTick.attach(&minUp, 60.0);
            }
                
            for( int h=0; h<16 ; h++ )
                LEDS[h] = 0;
            LEDS[colmn] = (unsigned short)bright;
            offDisp(blank, gsclk);
            if( colmn<8 )
                fontOut( decfont( min , colmn ) );
            else
                fontOut( hourDecfont( hour , colmn-8 ) );
            update_led (driver, xlat, blank, gsclk , LEDS);
            wait_us(dispTime);
        }
    }
    
    //1分増加させる　60になったら1時間増やす 12時間を超えたら1時に戻す
    min += 1;
    if( min >= 60 )
    {
        min = 0;
        hour++;
        if( hour > 12 )
            hour = 1;
    }
    
    for( int bright = 0 ; bright < brightMax; bright+=brightCangeValue )
    {
        for( int colmn=0 ; colmn<16 ; colmn++ )
        {
            //PWMをクリア
            for( int h=0; h<16 ; h++ )
                LEDS[h] = 0;
            LEDS[colmn] = (unsigned short)bright;    //必要なピンのみ指定した明るさでON
            offDisp(blank, gsclk);          //PWM強制OFF
            if( colmn<8 )
                fontOut( decfont( min , colmn ) );
            else
                fontOut( hourDecfont( hour , colmn-8 ) );
            update_led (driver, xlat, blank, gsclk , LEDS);
            wait_us(dispTime);
        }
    }

}



int main() {
    initFont();
    
    setup (driver, vprg, xlat, blank, gsclk, num_ics );
    brightCangeValue = brightChange;
    secTick.attach(&minUp, 60.0);   //1分でカウントアップ処理を行う
    
    while(1)
    {
        //スイッチが押された時の処理
        if( fastSw == 1 )
            minUp();
        if( slowSw == 1 )
            minUp();
        
        //16行分ダイナミック点灯させる
        for( int colmn=0 ; colmn<16 ; colmn++ )
        {
                
            for( int h=0; h<16 ; h++ )
                LEDS[h] = 0;
            LEDS[colmn] = (unsigned short)brightMax;
            offDisp(blank, gsclk);
            if( colmn<8 )
                fontOut( decfont( min , colmn ) );
            else
                fontOut( hourDecfont( hour , colmn-8 ) );
            update_led (driver, xlat, blank, gsclk , LEDS);
            wait_us(dispTime);
        }
    }
}
