#include "mbed.h"

/* 踏切を再現するプログラム */
/* 配線の仕方　*/
/*  https://kohacraft.com/archives/1035056914.html */
 

DigitalOut sp(dp1);     //スピーカーをつなぐピンを出力に設定
DigitalIn sw(dp2);      //スイッチをつなぐピンを入力に設定
DigitalOut led1(dp14);  //LED1をつなぐピンを出力に設定
DigitalOut led2(dp18);  //LED2をつなぐピンを出力に設定

int main() {
    //低い方の音
    double  MIonTime = (1.0/678)/4; //ミ
    double  MIoffTime = (1.0/678)/4;
    double  MISyuuki = MIonTime + MIoffTime;
        
    //高い方の音
    double  DOonTime = (1.0/761)/4; //ファ#
    double  DOoffTime = (1.0/761)/4;
    double  DOSyuuki = DOonTime + DOoffTime;
    
    while(1) {
        
        //両方のLEDを消す
        led1 = 0;
        led2 = 0;

        //スイッチが押されている間は踏切が鳴る
        while( sw == 1 )
        {
                    
            //片方のLEDだけを点灯
            led1 = 1;
            led2 = 0;

            for( int i=0 ; i<1000 ; i+=5 )
            {   
                //音をだんだん小さくするための計算
                double duty = (i / 1000.0)/2;
                double MIonTimeNow = MIonTime - (MISyuuki * duty);
                double MIoffTimeNow = MIoffTime + (MISyuuki * duty);
                double DOonTimeNow = DOonTime - (DOSyuuki * duty);
                double DOoffTimeNow = DOoffTime + (DOSyuuki * duty);
                
                sp = 1; //低い方の音をちょっと出す
                wait(MIonTimeNow); 
                sp = 0;
                wait(MIoffTimeNow); 
                sp = 1; //高い方の音ちょっと出す
                wait(DOonTimeNow); 
                sp = 0;
                wait(DOoffTimeNow);

            }
            wait (0.1);
            
            //もう片方のLEDだけを点灯
            led1 = 0;
            led2 = 1;

            for( int i=0 ; i<1000 ; i+=5 )
            {   
                //音をだんだん小さくするための計算
                double duty = (i / 1000.0)/2;                
                double MIonTimeNow = MIonTime - (MISyuuki * duty);
                double MIoffTimeNow = MIoffTime + (MISyuuki * duty);
                double DOonTimeNow = DOonTime - (DOSyuuki * duty);
                double DOoffTimeNow = DOoffTime + (DOSyuuki * duty);
                
                sp = 1; //低い方の音をちょっと出す
                wait(MIonTimeNow); 
                sp = 0;
                wait(MIoffTimeNow); 
                sp = 1; //高い方の音ちょっと出す
                wait(DOonTimeNow); 
                sp = 0;
                wait(DOoffTimeNow);

            }
            wait (0.1);
            
        }
             
    }
        
}
