#include "mbed.h"
#include "eink.h"

#include "SDFileSystem.h"
#define     SD_MOSI     dp2
#define     SD_MISO     dp1
#define     SD_SCLK     dp6
#define     SD_CS       dp4
SDFileSystem  sd(SD_MOSI, SD_MISO, SD_SCLK, SD_CS,  "sd");  //  mosi, miso, sclk, cs, name  (HW modification candidate)

DigitalOut myled(dp5);  //テスト用LED

int main() {
    initPort();   //IOの初期化
    
    wait_ms(500);

    myled = 1;
    FILE *fp;
    char filePath[256] = "";
    int fileNum = 1;

    while(1)
    {
        myled = 1;
        clrdisp(1); //白でクリア
        clrdisp(1); //白でクリア
        clrdisp(0); //白でクリア
        clrdisp(0); //白でクリア
        
        sprintf( filePath , "/sd/%02d.bmp" , fileNum );        
        if( ( fp = fopen(filePath, "r") ) == NULL )
        {
            fclose(fp);
            free(fp);
            while(1)
            {
                myled = 0;
                wait(0.1);
                myled = 1;
                wait(0.1);
                
            }
        }
        
        dispbmp2( fp );

        myled = 0;
        wait(0.5);
        fclose( fp );
        free(fp);
        
        powerOff();
        wait(5);
        powerOn();
        
    }
}