#include "mbed.h"
#include "extdio.h"


DigitalOut CL(dp9);
DigitalOut sdata(dp10);
DigitalOut sclock(dp11);
DigitalOut sdlatch(dp14);
DigitalOut sclatch(dp13);

char    contBasState = 0; //制御バスの設定   
bool    olddata[8] = { 0,0,0,0,0,0,0,0 };
void setCL( bool state )
{
    CL = state;
}

//制御バスピン変更
void setContBas( char mask , bool state )
{
    sclock = 0;
    sclatch = 0;
    if( state == true)
    {
        contBasState = contBasState | mask;
    }
    else
    {
        contBasState = contBasState & (~mask);
    }
    char sendData;
    sendData = contBasState;
    char bitMask = 0x80;

    //MSBから1bitずつ転送    
    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;
    
    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;

    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;

    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;

    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;

    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;

    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;

    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;
    
    //ラッチ
    sclatch = 1;
    sclatch = 0;
}

//データバスピン変更
void setDataBas( bool d7 ,  bool d6 ,  bool d5 ,  bool d4 ,  bool d3 ,  bool d2 ,  bool d1 ,  bool d0  )
{
    sclock = 0;
    sdlatch = 0;
    
    //過去と同じ値だったら上書きしない
    if( olddata[0] == d0 && olddata[1] == d1 && olddata[2] == d2 && olddata[3] == d3 && olddata[4] == d4 && olddata[5] == d5 && olddata[6] == d6 && olddata[7] == d7 )
    {
        return;
    } 
    
    olddata[0] = d0; olddata[1] = d1; olddata[2] = d2; olddata[3] = d3; olddata[4] = d4; olddata[5] = d5; olddata[6] = d6; olddata[7] = d7;
    
    sdata = d0;
    sclock = 1;
    sclock = 0;

    sdata = d1;
    sclock = 1;
    sclock = 0;

    sdata = d2;
    sclock = 1;
    sclock = 0;

    sdata = d3;
    sclock = 1;
    sclock = 0;

    sdata = d4;
    sclock = 1;
    sclock = 0;

    sdata = d5;
    sclock = 1;
    sclock = 0;

    sdata = d6;
    sclock = 1;
    sclock = 0;

    sdata = d7;
    sclock = 1;
    sclock = 0;

    //ラッチ
    sdlatch = 1;
    sdlatch = 0;
}

