#include "mbed.h"
#include "extdio.h"
#include "eink.h"

//ポートの初期化
void initPort()
{
    setCL( 0 );
    setContBas( LE , 0);
    setContBas( OE , 0);
    setContBas( NC10 , 1);
    setContBas( SPH , 1);

    setContBas( GMODE , 0);
    setContBas( SPV , 1);
    setContBas( CKV , 0);
    setContBas( EN , 0);
    
    setDataBas( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
}

//pageStart
void pageStart()
{   

    setContBas( GMODE , 1 );
    setContBas( CKV , 1 );
    wait_us(11);
    setContBas( SPV , 0 ); 
    wait_us(11);
    setContBas( CKV , 0 );
    wait_us(10);
    setContBas( CKV , 1 );
    wait_us(10);
    setContBas( SPV , 1 ); 
    wait_us(12);

    setContBas( CKV , 0 );
    wait_us(10);
    setContBas( CKV , 1 );
    wait_us(22);
    setContBas( CKV , 0 );
    wait_us(10);
    setContBas( CKV , 1 );
    wait_us(22);
    setContBas( CKV , 0 );
    wait_us(10);
    setContBas( CKV , 1 );
    wait_us(1);
}

//lineStart
void lineStart()
{
    
    setCL( 1 );
    setCL( 0 );
    setContBas( LE , 0 );
    wait_us(1);
    
    setCL( 1 );
    setCL( 0 );
    wait_us(1);

    setCL( 1 );
    setCL( 0 );
    wait_us(1);
    
    setCL( 1 );
    setCL( 0 );
    setContBas( OE , 1 );
    wait_us(1);

    setCL( 1 );
    setCL( 0 );
    setContBas( SPH , 0 );
}

//点を描画
void drowPixels( bool d7 ,  bool d6 ,  bool d5 ,  bool d4 ,  bool d3 ,  bool d2 ,  bool d1 ,  bool d0  )
{
    setDataBas( d7 ,  d6 ,  d5 ,  d4 ,  d3 ,  d2 ,  d1 ,  d0  );
    setCL( 1 );
    setCL( 0 );
}

//lineEnd
void lineEnd()
{
    setContBas( NC10 , 1 );
    setContBas( CKV , 0 );
    
    setCL( 1 );
    setCL( 0 );
    wait_us(10);
    
    setContBas( OE , 0 );
    setContBas( LE , 1 );
    setContBas( CKV , 1 );
    wait_us(1);
}

//pageEnd  
void pageEnd()
{
    setCL( 1 );
    setCL( 0 );
    setContBas( LE , 0 );
    
    setCL( 1 );
    setCL( 0 );

    setCL( 1 );
    setCL( 0 );

    setCL( 1 );
    setCL( 0 );
    setContBas( OE , 1 );

    setCL( 1 );
    setCL( 0 );
    
    for( int i=0 ; i<200 ; i++ )
    {
        setCL( 1 );
        setCL( 0 );
    }
    setContBas( CKV , 0 );
    
    setCL( 1 );
    setCL( 0 );
    
    wait_us(10);    
    setContBas( OE , 0 );
    
    wait_us(330);

    setContBas( GMODE , 0 );
    wait_us(130);

}

//SPHを交代する
void changeSPH()
{
    setContBas( SPH , 1 );
    setContBas( NC10 , 0 );
}

//画面をクリアする 0:黒 1:白
void clrdisp( bool color )
{
    pageStart();
    for( int j=0 ; j<600 ; j++)
    {
        lineStart(); 
        for( int i=0 ; i<100 ; i++ )            
        {
            if( color ==  1)
                drowPixels( 0 , 1 , 0 , 1 , 0 , 1 , 0 , 1 );    //白でクリアする
            else
                drowPixels( 1 , 0 , 1 , 0 , 1 , 0 , 1 , 0 );    //黒でクリアする
        }
        changeSPH();
        for( int i=100 ; i<200 ; i++ )
        {
            if( color ==  1)
                drowPixels( 0 , 1 , 0 , 1 , 0 , 1 , 0 , 1 );    //白でクリアする
            else
                drowPixels( 1 , 0 , 1 , 0 , 1 , 0 , 1 , 0 );    //黒でクリアする
        }
        lineEnd();
        
    }
    pageEnd();
}

void dispbmp(FILE *fp , bool mode )
{
        char bmpdata[12];
        int size;
        fseek(fp, 54 , SEEK_SET);//bitmap headder throw
        
        pageStart();    
        for( int j=0 ; j<600 ; j++)
        {
            lineStart();
            
            for( int i=0 ; i<100 ; i++ )
            {
                size = fread( bmpdata , sizeof(char) , 12 , fp);
                if( size < 12 )
                {                   
                    drowPixels( 0 , 1 , 0 , 1 , 0 , 1 , 0 , 1 );    //読み込めない場合は白にする
                }
                else
                {
                    if( mode == 0 )
                        drowPixels( bmpdata[9]==0 , bmpdata[9]>0 , bmpdata[6]==0 , bmpdata[6]>0 , bmpdata[3]==0 , bmpdata[3]>0 , bmpdata[0]==0 , bmpdata[0]>0 );
                    else
                        drowPixels( bmpdata[9]==0 , 1 , bmpdata[6]==0 , 1 , bmpdata[3]==0 , 1 , bmpdata[0]==0 , 1 );
                }
            }
            changeSPH();
            for( int i=100 ; i<200 ; i++ )
            {
                size = fread( bmpdata , sizeof(char) , 12 , fp);
                if( size < 12 )
                {
                    drowPixels( 0 , 1 , 0 , 1 , 0 , 1 , 0 , 1 );    //読み込めない場合は白にする
                }
                else
                {
                    if( mode == 0 )
                        drowPixels( bmpdata[9]==0 , bmpdata[9]>0 , bmpdata[6]==0 , bmpdata[6]>0 , bmpdata[3]==0 , bmpdata[3]>0 , bmpdata[0]==0 , bmpdata[0]>0 );
                    else
                        drowPixels( bmpdata[9]==0 , 1 , bmpdata[6]==0 , 1 , bmpdata[3]==0 , 1 , bmpdata[0]==0 , 1 );
                }

            }

            lineEnd();
        }
        pageEnd();
}

void dispbmp2(FILE *fp)
{
    dispbmp( fp , 0 ); //黒の部分描く
    fseek(fp, 0 , SEEK_SET);//bitmap headder throw
    dispbmp( fp , 1 ); //白の部分を描く
}

void powerOff()
{
    setContBas( EN , 1);

    setCL( 0 );
    setContBas( LE , 0);
    setContBas( OE , 0);
    setContBas( NC10 , 0);
    setContBas( SPH , 0);

    setContBas( GMODE , 0);
    setContBas( SPV , 0);
    setContBas( CKV , 0);
    
    setDataBas( 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 );
    
}

void powerOn()
{
    setContBas( EN , 0);
}