/* 電子ペーパー実験セットの実験プログラムです */

#include "mbed.h"
#include "eink.h"

//SDにアクセスするための設定
#include "SDFileSystem.h"
#define     SD_MOSI     dp2
#define     SD_MISO     dp1
#define     SD_SCLK     dp6
#define     SD_CS       dp4
SDFileSystem  sd(SD_MOSI, SD_MISO, SD_SCLK, SD_CS,  "sd");  //  mosi, miso, sclk, cs, name  (HW modification candidate)


DigitalIn key1(dp28);  //キー入力1
DigitalIn key2(dp25);  //キー入力2
DigitalIn key3(dp18);  //キー入力3
DigitalIn key4(dp15);  //キー入力4

int main() {
    
    initPort();   //IOの初期化

    //電子ペーパーの電源を入れる
    powerOn();
    
    FILE *fp;
    char filePath[32] = "";
    int fileNum = 0;
    

    //キーが押されるまでループし続ける
    while( fileNum == 0 )
    {
        if( key1 == 1 )
            fileNum = 1;
        if( key2 == 1 )
            fileNum = 2;
        if( key3 == 1 )
            fileNum = 3;
        if( key4 == 1 )
            fileNum = 4;
    }
    
    //ファイルのオープン
    sprintf( filePath , "/sd/%d.bmp" , fileNum);        
    fp = fopen(filePath, "r");

    /* -------------------------------------- */
    /* 描画モードはお手元の電子ペーパーに合わせて */
    /* 以下の3つのモードから、                  */
    /* 一番きれいに描画されるモードを1つお選び、  */
    /* 他のモードをコメントアウトしてください     */ 
    /* -------------------------------------- */

    //描画モード1 黒でクリアし、白の部分を描画する
    //電子ペーパー ED060SC4(LF)H2向け
    clrDisp(EDP_BLACK); //黒でクリアする
    clrDisp(EDP_BLACK); //何度かクリアするときれいに消えます
    dispBmp( fp , EDP_WHITE );    //ファイルポインタで指定したbmpファイルを表示する
    dispBmp( fp , EDP_WHITE );    //複数回描くと白がきれいになる

    //描画モード2　白でクリアし、黒の部分を描画する
    //電子ペーパー ED060SC4(LF)H2-00向け
    //            ED060SC4(LF)H1向け
    clrDisp(EDP_WHITE); //白でクリアする
    clrDisp(EDP_WHITE);
    dispBmp( fp , EDP_BLACK );
    dispBmp( fp , EDP_BLACK );

    //描画モード3　白でクリアし、白黒両方を描画する
    //電子ペーパー ED060SC4(LF)向け
    clrDisp(EDP_WHITE); //白でクリアする
    clrDisp(EDP_WHITE);
    dispBmp( fp , EDP_BLACK_WHITE );
    dispBmp( fp , EDP_BLACK_WHITE );

    //ファイルのクローズ
    fclose( fp );
    free(fp);
    
    //電子ペーパーの電源を切る
    powerOff();

    //電源OFF待ち
    while(1)
    {
        wait(1);
    }
}