/* 電子ペーパーインタフェース回路(シリアルパラレル変換)の制御用です */

#include "mbed.h"
#include "extdio.h"


DigitalOut CL(dp9);
DigitalOut sdata(dp10);
DigitalOut sclock(dp11);
DigitalOut sdlatch(dp14);
DigitalOut sclatch(dp13);

char    _contBusState = 0; //制御バスの状態保存
char    _olddata;   //データバスの過去データ保存

void setCL( bool state )
{
    CL = state;
    return;
}

//制御バスピン変更
void setContBus( char mask , bool state )
{
    sclock = 0;
    sclatch = 0;
    if( state == true)
    {
        _contBusState = _contBusState | mask;
    }
    else
    {
        _contBusState = _contBusState & (~mask);
    }
    char sendData;
    sendData = _contBusState;
    char bitMask = 0x80;

    //MSBから1bitずつ転送    
    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;
    
    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;

    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;

    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;

    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;

    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;

    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;

    sdata = sendData & bitMask;
    sclock = 1;
    bitMask = bitMask >> 1;
    sclock = 0;
    
    //ラッチ
    sclatch = 1;
    sclatch = 0;
    
    return;
}

//データバスピン変更
void setDataBus( char data )
{
    sclock = 0;
    sdlatch = 0;
    
    //過去と同じ値だったら上書きしない
    if( _olddata == data )
    {
        return;
    } 
    _olddata = data;
    
    sdata = data&0x01;
    sclock = 1;
    sclock = 0;

    sdata = data&0x02;
    sclock = 1;
    sclock = 0;

    sdata = data&0x04;
    sclock = 1;
    sclock = 0;

    sdata = data&0x08;
    sclock = 1;
    sclock = 0;

    sdata = data&0x10;
    sclock = 1;
    sclock = 0;

    sdata = data&0x20;
    sclock = 1;
    sclock = 0;

    sdata = data&0x40;
    sclock = 1;
    sclock = 0;

    sdata = data&0x80;
    sclock = 1;
    sclock = 0;

    //ラッチ
    sdlatch = 1;
    sdlatch = 0;
    
    return;
}
