/* 救急車のプログラムです */
#include "mbed.h"

DigitalOut sp(dp1); //スピーカーのピンを設定します
DigitalOut l1(dp13);//1つ目のLEDのピンを設定します
DigitalOut l2(dp14);//2つ目のLEDのピンを設定します
Ticker flipper;     //タイマー割り込みを利用します

void flip() {   //定期的にここのプログラ実行されます
    l1 = !l1;   //LED1がONだったら反対のOFFに、OFFだったら反対のONにします
    l2 = !l2;
}

int main() {
    
    l1 = 0;
    l2 = 1;    
    flipper.attach(&flip, 0.5); //0.5秒ごとにflipというプログラムを実行する
    
    while(1) {
        
        //250～750Hzへ周波数を上げていく
        for(int i = 0; i < 960.0*0.65 ; i += 1) {
            sp = 1;
            wait(1.0/960.0/2.0);
            sp= 0;
            wait(1.0/960.0/2.0);
        }
       
        //750～250Hzへ周波数を下げていく
        for(int i = 0; i < 770.0*0.65 ; i += 1) {
            sp = 1;
            wait(1.0/770.0/2.0);
            sp= 0;
            wait(1.0/770.0/2.0);
        }
        
    }
}
