/* 消防車のプログラムです */
#include "mbed.h"

DigitalOut sp(dp1); //スピーカーのピンを設定します
DigitalOut l1(dp13);//1つ目のLEDのピンを設定します
DigitalOut l2(dp14);//2つ目のLEDのピンを設定します
Ticker flipper;     //タイマー割り込みを利用します

void flip() {   //定期的にここのプログラ実行されます
    l1 = !l1;   //LED1がONだったら反対のOFFに、OFFだったら反対のONにします
    l2 = !l2;
}

int main() {
    
    l1 = 0;
    l2 = 1; //片方のLEDだけを光らせておく    
    flipper.attach(&flip, 0.5); //0.5秒ごとにflipというプログラムを実行する
    
    while(1) {
        
        //250～750Hzへ周波数を上げていく
        for(float p1 = 250.0; p1 <= 750.0 ; p1 += 0.5) {
            sp = 1;
            wait(1.0/p1/2);
            sp= 0;
            wait(0.2/p1/2);
        }
       
        //750～250Hzへ周波数を下げていく
        for(float p1 = 750.0; p1 >= 250.0 ; p1 -= 0.5) {
            sp = 1;
            wait(1.0/p1/2);
            sp= 0;
            wait(0.2/p1/2);
        }
        
    }
}
