/* カッコーが鳴る歩行者用信号のプログラムです */
#include "mbed.h"

DigitalOut sp(dp1); //スピーカーのピンを設定します
DigitalOut blue(dp13);//1つ目のLEDのピンを設定します
DigitalOut red(dp14);//2つ目のLEDのピンを設定します

int main() {
    

    while(1) {
        blue = 1;   //青を光らせる
        red = 0;    //赤を消す
                
        //カッコーを5回鳴らす
        for( int i=0 ; i<5 ; i++ )
        {   
            //ミの音を鳴らす
            for( int i=0 ; i<300 ; i++ )
            {
                sp = 1;   //スピーカーをON OFF させて音を作る
                wait(1.0/880.00/4); //1オクターブ上のミ 880*2Hz
                sp = 0;
                wait(1.0/880.00/4);
            
            }
            wait(0.2);
            
            //ドの音を鳴らす
            for( int i=0 ; i<700 ; i++ )
            {
            
                sp = 1;
                wait(1.0/698.45/4); //1オクターブ上のド 698.45*2Hz
                sp = 0;
                wait(1.0/698.45/4);
            
            }
            wait(0.8);
        }
        
        //青を点滅させる
        for( int i=0 ; i<5 ; i++ )
        {
            blue = 0;
            wait(0.25);
            blue = 1;
            wait(0.25);
        }
        
        //赤にする
        blue = 0;   //青を消す
        red = 1;    //赤を光らせる
        wait(5);
    }
}


