/* まばたきをするロボットのプログラムです */
#include "mbed.h"

DigitalOut sp(dp1); //スピーカーのピンを設定します
DigitalOut l1(dp13);//1つ目のLEDのピンを設定します
DigitalOut l2(dp14);//2つ目のLEDのピンを設定します

main() {
    float r;
    l1 = 0;
    l2 = 1;    
    
    while(1) {
        
        l1=0;   //まばたきのためLEDを消す
        l2=0;
        //ドの音から徐々に高い音へと変えていく
        for(float p1 = 523.0*2; p1 <= 2000*2 ; p1 *= 1.0594631) {
            for( int i=0 ; i<20 ; i++ ) {
            sp = 1;
            wait(1.0/p1/2);
            sp= 0;
            wait(1.0/p1/2);
            }
        }
        l1=1;   //目を光らせる
        l2=1;
        
        //0～3までのランダムな値を計算する
        r = (float)rand()/RAND_MAX*3.0;
        wait(r);    //次のまばたきまで0～3秒間のランダムな時間待つ
    }
}
