/* クラシック音楽の鳴る人形のプログラムです */
#include "mbed.h"

PwmOut sp(dp1); //スピーカーのピンを設定します
DigitalOut l1(dp13);//1つ目のLEDのピンを設定します
DigitalOut l2(dp14);//2つ目のLEDのピンを設定します
Ticker flipper;     //タイマー割り込みを利用します

void flip() {   //定期的にここのプログラ実行されます
    l1 = !l1;   //LED1がONだったら反対のOFFに、OFFだったら反対のONにします
    l2 = !l2;
}

//指定した周波数の音を指定した時間鳴らします  ヘルツ,秒
 void tone( float t , float n ){
    float na;

    na = 1 / n;
    for( int i=0 ; i< t / na  ; i++ ){
        sp = 1; 
        wait(1.0 / t / 2);
        sp = 0; 
        wait(1.0 / t / 2);
    }
}
                   
int main() {
    sp.period(0.00001); //PWMの周期を細かくしておく
    
    l1 = 0;
    l2 = 1; //片方のLEDだけを光らせておく    
    flipper.attach(&flip, 0.2); //0.2秒ごとにflipというプログラムを実行する
    
    while(1) {
        //  ヘルツ  秒
        tone( 784 , 0.4 );
        tone( 523.3 , 0.2 );        
        tone( 587.3 , 0.2 );
        tone( 659.3 , 0.2 );
        tone( 698.5 , 0.2 );
        
        tone( 784 , 0.4 );
        tone( 523.3 , 0.35 );
        wait(0.05);
        tone( 523.3 , 0.4 );
        
        tone( 880 , 0.4 );
        tone( 698.5 , 0.2 );        
        tone( 784 , 0.2 );
        tone( 880 , 0.2 );
        tone( 987.8 , 0.2 );
        
        tone( 1047 , 0.4 );
        tone( 523.3 , 0.35 );
        wait(0.05);
        tone( 523.3 , 0.4 );
        
        tone( 698.5 , 0.4 );
        tone( 784 , 0.2 );        
        tone( 698.5 , 0.2 );
        tone( 659.3 , 0.2 );
        tone( 587.3 , 0.2 );
   
        tone( 659.3 , 0.4 );
        tone( 698.5 , 0.2 );        
        tone( 659.3 , 0.2 );
        tone( 587.3 , 0.2 );
        tone( 523.3 , 0.2 );

        tone( 493.9 , 0.4 );
        tone( 523.3 , 0.2 );        
        tone( 587.3 , 0.2 );
        tone( 659.3 , 0.2 );
        tone( 523.3 , 0.2 );
        tone( 587.3 , 1.2 );
        
        tone( 784 , 0.4 );
        tone( 523.3 , 0.2 );        
        tone( 587.3 , 0.2 );
        tone( 659.3 , 0.2 );
        tone( 698.5 , 0.2 );
        
        tone( 784 , 0.4 );
        tone( 523.3 , 0.35 );
        wait(0.05);
        tone( 523.3 , 0.4 );
        
        tone( 880 , 0.4 );
        tone( 698.5 , 0.2 );        
        tone( 784 , 0.2 );
        tone( 880 , 0.2 );
        tone( 987.8 , 0.2 );
        
        tone( 1047 , 0.4 );
        tone( 523.3 , 0.35 );
        wait(0.05);
        tone( 523.3 , 0.4 );
        
        tone( 698.5 , 0.4 );
        tone( 784 , 0.2 );        
        tone( 698.5 , 0.2 );
        tone( 659.3 , 0.2 );
        tone( 587.3 , 0.2 );
   
        tone( 659.3 , 0.4 );
        tone( 698.5 , 0.2 );        
        tone( 659.3 , 0.2 );
        tone( 587.3 , 0.2 );
        tone( 523.3 , 0.2 );

        tone( 587.3 , 0.4 );
        tone( 659.3 , 0.2 );        
        tone( 587.3 , 0.2 );
        tone( 523.3 , 0.2 );
        tone( 493.9 , 0.2 );
        tone( 523.3 , 1.2 );                
     
        wait(0.4);
    }
}