#include "mbed.h"

/* 踏切を再現するプログラム */

DigitalOut sp(dp1);     //スピーカーをつなぐピンを出力に設定
DigitalIn sw(dp2);      //スイッチをつなぐピンを入力に設定
DigitalOut led1(dp14);  //LED1をつなぐピンを出力に設定
DigitalOut led2(dp18);  //LED2をつなぐピンを出力に設定


int main() {
    while(1) {
        
        //両方のLEDを消す
        led1 = 0;
        led2 = 0;
        
        //スイッチが押されているか調べて
        //押されていたらLEDを光らせ音を鳴らす
        if( sw == 1 )
        {
            
            //片方のLEDだけを点灯
            led1 = 1;
            led2 = 0;
            
            //ミの音をちょっと出す
            for( int i=0 ; i<20 ; i++ )
            {
                sp = 1;
                wait(1.0/1318.51/2);    //1318.51Hzがミの音
                sp = 0;
                wait(1.0/1318.51/2);        
            }
    
            
            //ドの音を長く出す
            for( int i=0 ; i<200*2 ; i++ )
            {
               sp = 0;
                wait(1.0/1046.50/2);    //1046.50Hzがドの音
                sp = 1;
                wait(1.0/1046.50/2);
            }
            wait (0.1);
            
            //もう片方のLEDだけを点灯
            led1 = 0;
            led2 = 1;
            
            //ミの音をちょっと出す
            for( int i=0 ; i<20*2 ; i++ )
            {
                sp = 1;
                wait(1.0/1318.51/2);
                sp = 0;
                wait(1.0/1318.51/2);
            }
    
            
            //ドの音を長く出す
            for( int i=0 ; i<200*2 ; i++ )
            {
                sp = 0;
                wait(1.0/1046.50/2);
                sp = 1;
                wait(1.0/1046.50/2);
            }
            wait (0.1);

        }
             
    }
        
}
