#include "TLC5940.h"

int num_drivers = 1;

void setup (SPI &driver, DigitalOut &vprg, DigitalOut &xlat, DigitalOut &blank, PwmOut &gsclk, int num_ics)
{
    driver.format (6,0);
    driver.frequency (20000000);
    if (num_ics <= 0)
    {
        num_drivers = 1;
    }
    else
    {
        num_drivers = num_ics;
    }

    xlat = 0;               // hold GS/DC data constant
    blank = 0;
    blank = 1;
    blank = 0;              // Blank (squelch) all outputs
    
    //補正データを最大に設定
    vprg = 1;
    for (int i = 0; i<16*num_ics; i++)
    {
        driver.write (0x3F);   //最大
    }
    xlat = 1;
    xlat = 0;               // hold GS/DC data constant
    
    driver.format (12,0);
    vprg = 0;               // sets drivers to GS mode. Set to 1 to change to DC mode
    gsclk.period_us (1.0);    // set grayscale clock to 1000 Hz
    gsclk = 0.5;            // turn on grayscale clock to 50% duty cycle at afore mentioned frequency
    
    
    
}


void update_led (SPI &driver, DigitalOut &xlat, DigitalOut &blank, PwmOut &gsclk, unsigned short* LEDS)
{
    blank = 1;
    for (int k = (num_drivers - 1); k >= 0; k--)
    {
        for (int i = (16 - 1); i >= 0; i--)
        {
            driver.write (*(LEDS + k + i));
        }
    }
    wait_us(10);
    xlat = 1;
    xlat = 0;
    blank = 0;
    driver.format (12,0);

}

void offDisp(DigitalOut &blank , PwmOut &gsclk)
{
    blank = 1;
}

   