/*
 * ======================
 * VS-C3/VS-RCV3 PIN
 * ======================
 * 1:NC  2:NC
 * 3:DAT 4:CMD
 * 5:SEL 6:CLK
 * 7:+5~7V 8:NC
 * 9:+3V 10:GND
 *
 */
 
#include "mbed.h"
#include "PS_PAD.h"

class Motor{
    PwmOut a, b;
public:
    Motor(PinName A_term, PinName B_term) : a(A_term), b(B_term) {
        a.period(0.0002);
        b.period(0.0002);
    }
    
    Motor& operator=(double duty) {
        if(duty > 0){
            a = duty < 1 ? duty : 1;
            b = 0;
        }else {
            a = 0;
            b = duty > -1 ? -duty : 1;
        }
        return *this;
    }
    operator double() {
        if(a > 0)
            return (double)a;
        else
            return -(double)b;
    }
};
 
DigitalOut Led[] = {PB_7, PB_14, PB_0, };
PS_PAD vsc3(PA_7, PA_6, PA_5, PA_4); //MOSI, MISO, SCK, SS
 
DigitalIn lim[7] = {PD_2, PD_3, PD_4, PD_5, PD_6, PD_7, PG_9};
Motor rmotor(PE_9, PE_11);
Motor lmotor(PE_13, PE_14);
Motor rsmotor(PA_0, PA_1);
Motor lsmotor(PA_2, PA_3);
Motor prmotor(PC_8, PC_9);
Motor plmotor(PC_6, PC_7);
PwmOut erservo(PD_14);
PwmOut elservo(PD_15);

 
int main() {
    vsc3.init();
    int n = 0;
    double movey = 0, turn = 0, speed1 = 0.5, speed2 = 0.5; 
    double speed3 = 0, speed4 = 0 ;
    bool selcli = false, stacli = false;
    printf("START\n");
    elservo.period(0.020);
    erservo.period(0.020);
    
    while(1) {
        vsc3.poll();
        if (vsc3.read(PS_PAD::PAD_BOTTOM)){
            movey = -1;
        }else if (vsc3.read(PS_PAD::PAD_TOP)){
            movey = 1;
        /*}else if (abs(vsc3.read(PS_PAD::ANALOG_LY)) > 10){
            movey = (vsc3.read(PS_PAD::ANALOG_LY)) / 128.0;*/
        }else{
            movey = 0;
        }
               
        if (vsc3.read(PS_PAD::PAD_RIGHT)){
            turn = 0.8;
        }else if (vsc3.read(PS_PAD::PAD_LEFT)){
            turn = -0.8;
        /*}else if (abs(vsc3.read(PS_PAD::ANALOG_LX)) > 10){
            turn = (vsc3.read(PS_PAD::ANALOG_LX)) / 128.0;*/
        }else{
            turn = 0;
        }
        
        rmotor = -movey+turn;      //move
        lmotor = -movey-turn;
        
        /*saramawashi*/
      
        
        if (vsc3.read(PS_PAD::PAD_R2) /*&& lim[0] == 0*/){        //limitswitch
            rsmotor = speed1;
        }else if (vsc3.read(PS_PAD::PAD_R1) /*&& lim[0] == 0*/){        //limitswitch
            rsmotor = -speed1; 
        }else {
            rsmotor = 0;
        } 
        if (vsc3.read(PS_PAD::PAD_L2) /*&& lim[0] == 0*/){        //limitswitch
            lsmotor = speed2;
        }else if (vsc3.read(PS_PAD::PAD_L1) /*&& lim[0] == 0*/){        //limitswitch
            lsmotor = -speed2;
            
        }else {
            lsmotor = 0;
        }
        
        if (vsc3.read(PS_PAD::PAD_SELECT) && !selcli){
            n++;
            speed1 = 0.05*n*n;
            speed2 = 0.05*n*n;
            if (speed1 < 0)
                speed1 = 0;
            if (speed2 < 0)
                speed2 = 0;
            if ( n < 0)
                 n = 0;
                selcli = true;
        }
        if (!vsc3.read(PS_PAD::PAD_SELECT)){
                selcli = false;
        }
                
        if (vsc3.read(PS_PAD::PAD_START) && !stacli){
            n--;
            speed1 = 0.05*n*n;
            speed2 = 0.05*n*n;
            if (speed1 > 1)
                speed1 = 1;
            if (speed2 > 1)
                speed2 = 1;
            if ( n > 1)
                 n = 1;
                stacli = true;
        }
        if (!vsc3.read(PS_PAD::PAD_START)){
            stacli = false;
        }
        
        if (vsc3.read(PS_PAD::ANALOG_RY) > 100){
             speed3 += 0.03;
             speed1 += 0.05;
             if(speed3 > 0.3)
                speed3 = 0.3;
        }else if (vsc3.read(PS_PAD::ANALOG_RY) < -100){
             speed3 -= 0.03;
             speed1 -= 0.05;
             if(speed3 < -0.3)
                speed3 = -0.3;
        }else {
            if(speed3 < 0){
                speed3 += 0.03;
                if(speed3 > 0)
                    speed3 = 0;
            }else if(speed3 > 0){
                speed3 -= 0.03;
                if(speed3 < 0)
                    speed3 = 0;
            }
        }
        
        prmotor = speed3;
        
        if (vsc3.read(PS_PAD::ANALOG_LY) > 100){
             speed4 += 0.03;
             speed2 += 0.05;
             if(speed4 > 0.3)
                speed4 = 0.3;
        }else if (vsc3.read(PS_PAD::ANALOG_LY) < -100){
             speed4 -= 0.03;
             speed2 -= 0.05;
             if(speed4 < -0.3)
                speed4 = -0.3;
        }else {
            if(speed4 < 0){
                speed4 += 0.03;
                if(speed4 > 0)
                    speed4 = 0;
            }else if(speed4 > 0){
                speed4 -= 0.03;
                if(speed4 < 0)
                    speed4 = 0;
            }
        }
        
        plmotor = speed4;
        
        //eye move
        if (vsc3.read(PS_PAD::PAD_SQUARE)){
            elservo.pulsewidth(0.0017);
            erservo.pulsewidth(0.0012);
        }else if (vsc3.read(PS_PAD::PAD_CIRCLE)){
            elservo.pulsewidth(0.0012);
            erservo.pulsewidth(0.0017);
        }else if (vsc3.read(PS_PAD::PAD_TRIANGLE)){
            elservo.pulsewidth(0.0015);
            erservo.pulsewidth(0.0015);
        }
        
                
        /*if (vsc3.read(PS_PAD::PAD_L1) && lim[6] == 0){
            tlmotor = 1;
        }else if (vsc3.read(PS_PAD::PAD_L2) && lim[7] == 0){
            tlmotor = -1;
        }else{
            tlmotor = 0;
        }*/
        
        wait(0.05);
    }
}