/*
 * ======================
 * VS-C3/VS-RCV3 PIN
 * ======================
 * 1:NC  2:NC
 * 3:DAT 4:CMD
 * 5:SEL 6:CLK
 * 7:+5~7V 8:NC
 * 9:+3V 10:GND
 *
 */
 
#include "mbed.h"
#include "PS_PAD.h"

class Motor{
    PwmOut a, b;
public:
    Motor(PinName A_term, PinName B_term) : a(A_term), b(B_term) {
        a.period(0.001);
        b.period(0.001);
    }
    
    Motor& operator=(double duty) {
        if(duty > 0){
            a = duty < 1 ? duty : 1;
            b = 0;
        }else {
            a = 0;
            b = duty > -1 ? -duty : 1;
        }
        return *this;
    }
      operator double() {
        if(a > 0)
            return (double)a;
        else
            return -(double)b;
    }
};


PS_PAD vsc3(PA_7, PA_6, PA_5, PA_4); //MOSI, MISO, SCK, SS

DigitalIn lim[7] = {PD_2, PD_3, PD_4, PD_5, PD_6, PD_7, PG_9};
Motor rmotor(PE_9, PE_11);
Motor lmotor(PE_13, PE_14);
Motor sxmotor(PA_0, PA_1);
Motor tsmotor(PA_2, PA_3);
Motor trmotor(PC_6, PC_7);
Motor tlmotor(PC_8, PC_9);

int main() {
    vsc3.init();
    double movery = 0, movely = 0 , speed = 1 ;
    printf("START\n");
    
    while(1) {
        vsc3.poll();
        
        if(abs(vsc3.read(PS_PAD::ANALOG_RY)) > 10){
            movery = (vsc3.read(PS_PAD::ANALOG_RY)) / 284.4 ;
        }else{
            movery = 0;
        }
         if(abs(vsc3.read(PS_PAD::ANALOG_LY)) > 10){
            movely = (vsc3.read(PS_PAD::ANALOG_LY)) / 284.4 ;
        }else{
            movely = 0;
        }
        rmotor = movery;      //move
        lmotor = -movely;
        
        /* paper makiage*/
        
        if (vsc3.read(PS_PAD::PAD_SQUARE)/* && lim[2] == 0*/){
            sxmotor = speed;
        }else if (vsc3.read(PS_PAD::PAD_X) /*&& lim[3] == 0*/){
                  sxmotor = -speed;
        }else{
            sxmotor = 0;
        }        
        
        /* fan right */
        if (vsc3.read(PS_PAD::PAD_L1) /*&& lim[4] == 0*/){
            tsmotor = speed;
        }else{
            tsmotor = 0;
        }
               
        /* fan left */ 
        if (vsc3.read(PS_PAD::PAD_R1) /*&& lim[6] == 0*/){
            trmotor = speed;
        }else{
            trmotor = 0;
        }
        
        /*fan makiage double*/
         if (vsc3.read(PS_PAD::PAD_L1)&& vsc3.read(PS_PAD::PAD_R1)&& vsc3.read(PS_PAD::PAD_SQUARE)/*&& lim[4] == 0*/){
            tsmotor = 0.5;
            trmotor = 0.5;
            sxmotor = speed;
        }
         if (vsc3.read(PS_PAD::PAD_L1)&& vsc3.read(PS_PAD::PAD_R1)&& vsc3.read(PS_PAD::PAD_X)/*&& lim[4] == 0*/){
            tsmotor = 0.5;
            trmotor = 0.5;
            sxmotor = -speed;
        }
        
        wait(0.05);
    }
}