#ifndef _COLOR_H_
#define _COLOR_H_

/**
    RGB Color
*/
struct Color {
    
    /**
        Constructor with rgb initializing
    
        @param r - the red byte
        @param g - the green byte
        @param b - the blue byte
    */
    Color(uint8_t r, uint8_t g, uint8_t b) {
        red = r;
        green = g;
        blue = b;
    }

    /**
        Default constructor
    */
    Color() {
    }

    /**
        Red byte
    */
    uint8_t red;

    /**
        Green byte
    */
    uint8_t green;

    /**
        Blue byte
    */
    uint8_t blue;
};

/**
    Order of r, g and b bytes
*/
enum ColorByteOrder {
    RGB,
    RBG,
    GRB,
    GBR,
    BRG,
    BGR,
};


#endif