#include "LEDArray.h"

LEDArray::LEDArray(PinName wirePin, ColorByteOrder byteOrder, unsigned int numberOfLEDs, float t0h_us, float t0l_us, float t1h_us, float t1l_us, float tReset_us) : _ledBus(wirePin, byteOrder, t0h_us, t0l_us, t1h_us, t1l_us, tReset_us)
{
    initialize(numberOfLEDs);
}

LEDArray::LEDArray(PinName wirePin, ColorByteOrder byteOrder, unsigned int numberOfLEDs) : _ledBus(wirePin, byteOrder, 0.35, 0.8, 0.7, 0.6, 50)
{
    initialize(numberOfLEDs);
} 

LEDArray::~LEDArray()
{
}

void LEDArray::initialize(unsigned int numberOfLEDs)
{
    _numberOfLEDs = numberOfLEDs;
    _leds = new Color*[_numberOfLEDs];
    for(uint32_t i = 0; i < _numberOfLEDs; ++i)
    {
        _leds[i] = new Color(0,0,0);    
    }    
}

void LEDArray::setPixelColor(unsigned int pixel, uint8_t r, uint8_t g, uint8_t b)
{
    _leds[pixel]->red = r;
    _leds[pixel]->green = g;
    _leds[pixel]->blue = b;
}

void LEDArray::setPixelColor(unsigned int pixel, Color& color)
{
    setPixelColor(pixel, color.red, color.green, color.blue);    
}

void LEDArray::show()
{
    _ledBus.write(_leds, _numberOfLEDs);    
}