/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering University of Leeds
Name: Kostadin Chakarov
Username: el17kec
Student ID Number:201171978 Date:11/03/2019
*/

// Breakout logo sprite 
const int breakout[10][75] =   {
    { 1,0,0,1,1,0,0,0,0,0,1,0,0,1,1,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1,1,1,1,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0 },
    { 1,0,1,0,0,1,0,0,1,0,1,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,1,1,1,0,0,1,0,1,1,1,1,1,1,1,1,1 },
    { 1,1,0,0,0,0,1,0,0,1,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,1,1,1,0,0,1,0,0,0,0,0,1,0,0,0,0 },
    { 1,1,0,1,1,1,1,0,0,0,1,1,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0 },
    { 1,0,1,0,0,1,1,0,0,0,1,1,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0 },
    { 1,1,0,1,1,0,0,1,0,0,1,0,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,1,0,1,1,1,0,1,0,1,1,1 },
    { 1,1,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,1,1,1,1,1,1,1,1,0,0,1,0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,1,0 },
    { 1,1,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,1,1,1,0,1,0,0,1,0,0,0,0,1,0,0,0,0,0,1,1,1,1,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0 },
    { 1,0,1,0,0,0,1,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,1,1,0,0,1,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0 },
    { 1,0,0,1,1,1,0,0,0,0,1,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,0,0,0,0,1,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0 },
};

///////// pre-processor directives ////////
#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Paddle.h"
#include "Ball.h"
#include "Map.h"

#define WITH_TESTING
#ifdef WITH_TESTING
#include "tests.h"
#endif

const int fps = 20; // Sets the fps of the game, doesn't change 

/////////////// objects ///////////////
AnalogIn pot(PTB2); // Potentiometer to set contrast of screen 
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);  // K64F - pwr from 3V3
Gamepad pad; // Gamepad buttons 
Paddle paddle; // Paddle object 
Ball ball; // Ball object 
Map map; // Map object 

///////////// function prototypes ///////////////
void init();        // Initialize LCD and Gamepad 
void welcome();     // Simple welcome screen displayed on start-up 
void render();      // Used as the game loop
void contrast();    // Allows to set contrast, if not suitable  

///////////// functions ////////////////
int main() 
{
#ifdef WITH_TESTING
int number_of_failures = run_tests();
if(number_of_failures > 0) return number_of_failures;  
#endif
 
    init();     // Initialize LCD and Gamepad 
    welcome();  // Waiting for the user to start  
    render();   // Game Loop  
}


void init() 
{
  lcd.init();               // Initialize the LCD 
  pad.init();               // Initialize the Gamepad 
  lcd.setContrast(0.55);    // Initially set contrast to 55% 
  lcd.normalMode();         // Normal color mode 
  lcd.setBrightness(0.5);   // Puts LED backlight on 50% 
}   

/** Simple welcome screen displayed on start-up */
void welcome() 
{
    lcd.printString("Welcome to",12,0);
    lcd.drawSprite(5,15,10,75,(int *)breakout); // x origin, y origin, rows, cols, sprite
    lcd.printString("Press A ",2,4);
    lcd.printString("for Controls ",11,5);
    lcd.refresh();   
    
    // Wait to move to next menu 
    while (pad.check_event(Gamepad::A_PRESSED) == false) 
    {

    }
    lcd.clear();  
    lcd.printString("Use pot to ->",4,0);
    lcd.printString("set contrast",4,1);
    lcd.printString("Use Joystick ",6,2);
    lcd.printString("to move paddle ",0,3);
    lcd.printString("Press Start ",9,4);
    lcd.printString("to begin ",16,5);
    lcd.refresh();  
    // Flash LEDs until start button is pressed 
    while (pad.check_event(Gamepad::START_PRESSED) == false) 
    {
        for (int i = 1; i < 7; i++) 
        {
            pad.led(i,1);
            wait(0.1);
            pad.led(i,0);
        }  
    }
}

/** Resets everything if game is won / lost */
void resetGame()
{
    paddle.reset(); // Reset paddle
    ball.reset();   // Reset ball 
    map.reset();    // Reset map 
    map.score = 0;  // Reset score 
}

/** Checks if game is lost */
void checkLost()
{
    const Vector2D& posPad = paddle.getPos();
    // Checks if ball is below paddle, i.e. lost 
    if (ball.getPos().y > posPad.y) 
    {
        while (1) 
        {
            // Prints a simple 'lost' message and score and asks if you want to restart
            lcd.clear();
            char finalscore[14];
            sprintf(finalscore,"Score = %d",map.score);
            lcd.printString(finalscore,0,0);
            lcd.printString("You Lost",17,2);
            lcd.printString("Press A",20,3);
            lcd.printString("to restart",12,4);
            wait(0.1);
            lcd.refresh();
            // Checks if reset button is pressed, if it is reset 
            if (pad.check_event(Gamepad::A_PRESSED) == true)
            {
                resetGame();
                break;           
            }
        }
    }
}

/** Checks if level / game is won */
void checkWon() 
{
    if (map.checkLevel()) {
        // We have cleared a level 
        ball.reset();       // Reset ball 
        paddle.reset();     // Reset paddle 
        
        if (map.hasWon()) {
             // We have cleared all levels 
             while (1) 
            {   
                // Prints win message and score and asks if you want to restart 
                lcd.clear();
                char finalscore[14];
                sprintf(finalscore,"Score = %d",map.score);
                lcd.printString(finalscore,0,0);
                lcd.printString("You WON!",17,2);
                lcd.printString("Press B",20,3);
                lcd.printString("to restart",12,4);
                wait(0.1);
                lcd.refresh();
                // Checks if reset button is pressed, if it is reset 
                if (pad.check_event(Gamepad::B_PRESSED) == true)
                {
                    resetGame();
                    break;           
                }
            }
        }
    }
}

/** Game loop */
void render() 
{
    
    
    map.initBricks(); // Initialize the map 
    
    while(1) 
    {  
        
        // Physics, movement, control input + game logic 
        // Control Input 
        paddle.controlPaddle(pad); 
        
        // Movement and physics 
        ball.move();
        paddle.move();
        
        map.checkCollision(ball, paddle);
        map.update();
        ball.hitPad(paddle);
        
        // Rendering 
        lcd.clear();        // Initialize render 
        contrast();         // Sets contrast 
        map.drawMap(lcd);   // Draw map objects 
        paddle.draw(lcd);   // Draws paddle 
        ball.draw(lcd);     // Draws ball 
        
        lcd.refresh();      // Finalize render 
        
        wait(1.0f/fps);     // Frames per second 
        
        // Check Lost/Won 
        checkLost();
        checkWon();
    }
}

/** Allows to set contrast, if not suitable */
void contrast() 
{
    float contrast = pot.read(); // Read value from potentiometer(0-1) 
    lcd.setContrast(contrast); // Set that value for the contrast 
}
    