#ifndef PADDLE_TEST_H
#define PADDLE_TEST_H

/**
 * @brief Check that Paddle object goes to correct position when moved
 * 
 * @return true if all the tests passed
 */
bool Paddle_test_movement()
{
    // Initialise Ball object with the reset function
    Paddle paddle;
    paddle.reset();
    

    // Read the position
    Vector2D read_pos_1 = paddle.getPos();
    printf("%f, %f\n", read_pos_1.x, read_pos_1.y);


    // Move the paddle (It won't move so the position should be the same,
    // as joystick is not touched)
    paddle.move();

    // Read the position
    Vector2D read_pos_2 = paddle.getPos();
    printf("%f, %f\n", read_pos_2.x, read_pos_2.y);
    
    // Now check that both the positions are as expected
    bool success_flag = true;
    
    // Fail the test if the initial position is wrong
    if (read_pos_1.x != WIDTH/2 || read_pos_1.y != HEIGHT - GAP) {
        success_flag = false;
    }
    
    // Fail the test if the final position is wrong
    if (read_pos_2.x != WIDTH/2 || read_pos_2.y != HEIGHT - GAP) {
        success_flag = false;
    }

    return success_flag;
}
#endif