#ifndef GAMEOBJECT_H
#define GAMEOBJECT_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** StaticGameObject Class
, Draws and controls the objects in the Breakout game, which are static
@author Kostadin Chakarov, University of Leeds
@date April 2019 
*/ 

class StaticGameObject
{
public:
    /** Constructor */
    StaticGameObject();
    /** Destructor */
    ~StaticGameObject();
    /** Controls the movement physics of static game objects: Does nothing but is overwritten in GameObject. */
    virtual void move();
    /** Draws the game object */
    virtual void draw(N5110 &lcd);
    /** Gets the x and y coordinates of game object */
    const Vector2D& getPos() const;
    /** Gets the width of the game object 
    * @return the width of the game object
    */
    int getW() { return w; };
    /** Gets the height of the game object 
    * @return the height of the game object
    */
    int getH() { return h; };
    /** Sets the width of any game object
    * @param value - sets the width of the game objects equal to it
    * @details Used for the power-up features
    */
    void setW(int value) { w = value;}
protected:
    int w, h; /** width and height of any game object */
    Vector2D pos; /** x and y position of any game object */
};

/** GameObject Class
, Draws and controls the objects in the Breakout game, which are non-static, inherits from StaticGameObject
@author Kostadin Chakarov, University of Leeds
@date April 2019
*/ 

class GameObject : public StaticGameObject
{
public:
    /** Constructor */
    GameObject() : StaticGameObject() {}
    /** Controls the movement physics of non-static game object */
    virtual void move();
    /** Gets the velocity of the game object 
    * @return the velocity of the game object
    */
    Vector2D& getVelocity() { return velocity; }
    
protected:
    Vector2D velocity; /** velocity of non-static game object */ 
};
#endif