#ifndef BALL_TEST_H
#define BALL_TEST_H

/**
 * @brief Check that Ball object goes to correct position when moved
 * 
 * @return true if all the tests passed
 */
bool Ball_test_movement()
{
    // Initialise Ball object with the reset function
    Ball ball;
    ball.reset();
    
    // Read the position
    Vector2D read_pos_1 = ball.getPos();
    printf("%f, %f\n", read_pos_1.x, read_pos_1.y);


    // Move the ball (Update the position)
    ball.move();

    // Read the position
    Vector2D read_pos_2 = ball.getPos();
    printf("%f, %f\n", read_pos_2.x, read_pos_2.y);
    
    // Now check that both the positions are as expected
    bool success_flag = true;
    
    // Fail the test if the initial position is wrong
    if (read_pos_1.x != 42 || read_pos_1.y != 42) {
        success_flag = false;
    }
    
    // Fail the test if the final position is wrong
    if ((read_pos_2.x == 43) || (read_pos_2.y == 41) || (read_pos_2.x == 41)) {
        success_flag = true;
    }
    else {
        success_flag = false;
    }

    return success_flag;
}
#endif