#ifndef PADDLE_H
#define PADDLE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "GameObject.h"

/** number of pixels on display */
#define WIDTH 84 /**< width of screen */
#define HEIGHT 48 /**< height of screen */
// gap from edge of screen
#define GAP 4 /**< distance of pad from bottom of screen */

/** Paddle Class
, Controls for the paddle in the Breakout game, inherits from GameObject, because the paddle is a game object
@author Kostadin Chakarov, University of Leeds
@date March 2019
*/

class Paddle : public GameObject
{

public:
    /** Constructor */
    Paddle();
    /** Destructor */
    ~Paddle();
    /** Determines control method for paddle */
    void controlPaddle(Gamepad &pad);
    /** Controls movement of paddle */
    virtual void move();
    /** Resets paddle to initial starting point */
    void reset();
    /** Gets the speed of the paddle 
    * @return the speed of the paddle
    */
    float getSpeed() {return _speed;}
    /** Sets the speed of the paddle 
    * @param value - sets the speed equal to it
    */
    void setSpeed(float value) { _speed = value;}

private:
    Direction _d; /** Allows controlling with the joystick */
    float _speed; /** Speed of the paddle */
};

#endif