#include "Paddle.h"

Paddle::Paddle()
{
    reset(); // initial parameters of paddle 
}

Paddle::~Paddle()
{
}

void Paddle::controlPaddle(Gamepad &pad)
{
    // Sets the joystick as the paddle controller 
    _d = pad.get_direction();

}

void Paddle::move()
{
    // Moving right 
    if (_d == E) {
        pos.x = pos.x + _speed; // Adds speed to current position on x-axis 
        
        if (pos.x >= WIDTH - w) {
            pos.x = WIDTH - w; // Sets the right-most limit to paddle
        }
    }
    // Moving left 
    if (_d == W) {
        pos.x = pos.x - _speed; // Subtracts speed from current position on x-axis 
        
        if (pos.x <= 0) {
            pos.x = 0; // Sets the left-most limit to paddle
        }
    }
}

void Paddle::reset()
{
    pos.x = WIDTH/2;        // position of paddle on x-axis 
    pos.y = HEIGHT - GAP;   // position of paddle on y-axis 
    velocity.x = 0;         // x-velocity of paddle is zero as it does not move by itself 
    velocity.y = 0;         // y-velocity of paddle is zero as it does not move by itself 
    w = 12;                 // width of the paddle 
    h = 2;                  // height of the paddle 
    _speed = 2;             // speed of movement of paddle 
}