#ifndef TESTS_H
#define TESTS_H


#include "Paddle.h"
#include "Ball.h"
#include "Ball-test.h"
#include "Paddle-Test.h"
/**
 * @brief Run all the tests for this program
 *
 * @returns The number of tests that failed
 */
int run_tests()
{
    int n_tests_failed = 0; // A log of the number of tests that have failed

    // Run the Ball_test_movement test
    printf("Testing Ball_test_movement...\n");
    bool Ball_test_passed = Ball_test_movement();

    // Print out the result of this test
    if (Ball_test_passed) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    // Run the Paddle_test_movement test
    printf("Testing Paddle_test_movement...\n");
    bool Paddle_test_passed = Paddle_test_movement();

    // Print out the result of this test
    if (Paddle_test_passed) {
        printf("...Passed!\n");
    }
    else {
        printf("...FAILED!\n");
        ++n_tests_failed; // Increment number of failures
    }
    
    // Finish by printing a summary of the tests
    if (n_tests_failed > 0) {
        printf("%d tests FAILED!\n", n_tests_failed);
    }
    else {
        printf("All tests passed!\n");
    }

    return n_tests_failed;
}

#endif