#ifndef BALL_H
#define BALL_H

#include "mbed.h"
#include "N5110.h"
#include "GameObject.h"
#include "Gamepad.h"
#include "Paddle.h"

/** Ball Class
, Controls the ball in the Breakout game, inherits from GameObject, because the ball is a game object
@author Kostadin Chakarov, University of Leeds
@date March 2019
*/

class Ball : public GameObject
{

public:
    /** Constructor */
    Ball();
    /** Destructor */
    ~Ball();
    /** Controls movement physics of paddle */
    virtual void move();
    /** Checks for collision between ball and paddle and resolves it */
    void hitPad(Paddle &paddle);
    /** Randomizes the initial x-direction of the ball 
    * @return either 1 or -1 for the initial x-velocity of the ball
    */
    int randomize();
    /** Resets ball to initial starting point */
    void reset();

private:
};
#endif