#include "mbed.h"
#include "C12832.h"
#include "pwm_tone.h"

//DigitalOut myled(LED1);
PwmOut Buzzer(D5);
C12832 lcd(p5, p7, p6, p8, p11);
AnalogIn sensor(p16);
PwmOut spkr(p26);
BusOut RGB (p23, p24, p25);

float C_3 = 1000000/Do3,
       Cs_3 = 1000000/Do3s,
       D_3 = 1000000/Re3,
       Ds_3 = 1000000/Re3s,
       E_3 = 1000000/Mi3,
       F_3 = 1000000/Fa3,
       Fs_3 = 1000000/Fa3s,
       G_3 = 1000000/So3,
       Gs_3 = 1000000/So3s,
       A_3 = 1000000/La3,
       As_3 = 1000000/La3s,
       B_3 = 1000000/Ti3,
       C_4 = 1000000/Do4,
       Cs_4 = 1000000/Do4s,
       D_4 = 1000000/Re4,
       Ds_4 = 1000000/Re4s,
       E_4 = 1000000/Mi4,
       F_4 = 1000000/Fa4,
       Fs_4 = 1000000/Fa4s,
       G_4 = 1000000/So4,
       Gs_4 = 1000000/So4s,
       A_4 = 1000000/La4,
       As_4 = 1000000/La4s,
       B_4 = 1000000/Ti4,
       C_5 = 1000000/Do5,
       Cs_5 = 1000000/Do5s,
       D_5 = 1000000/Re5,
       Ds_5 = 1000000/Re5s,
       E_5 = 1000000/Mi5,
       F_5 = 1000000/Fa5,
       Fs_5 = 1000000/Fa5s,
       G_5 = 1000000/So5,
       Gs_5 = 1000000/So5s,
       A_5 = 1000000/La5,
       As_5 = 1000000/La5s,
       B_5 = 1000000/Ti5;
       
int tones[] = {E_4, D_4, C_4, D_4, E_4, E_4, E_4, 0, D_4, D_4, D_4, 0, E_4, G_4, G_4, 0, 
                             E_4, D_4, C_4, D_4, E_4, E_4, E_4, 0, D_4, D_4, E_4, D_4, C_4, 0, 0, 0};
int tones_num = 32;

                         
float multiplier = 50;    // this number got me closest to the reading on my multimeter temp probe
float temp;               // calculated temperature
int count;                // for computing average reading
float total;
float average;
int MAX = 22;
int MIN = 20;
int Boiler_MAX = MIN + 2;


void buzz()
{
       for (float i=2000.0; i<7000.0; i+=1000) {
            spkr.period(0.5/i);
            spkr=0.1;
            wait(0.1);
        }
        spkr=0.0;
}

int main() {
    count = 0;
    total = 0.0;
//    RGB = 0xFF;
//    buzz();
    
    while (1) {
        // formula is analog reading * multiplier

        temp = sensor.read() * multiplier;
        count++;
        total += temp;
        average = total / count;
        
        if(temp > MAX)
        {
            RGB = 0xff;
            buzz();
        }
        else
        {
            RGB = 0x19;
        }
        
        if(temp < MIN)
        {
            RGB = 0x06;
        }
        else
        {
            RGB = 0x19;
        }
        
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Temperature= %6.2f \n Average= %5.1f \n", temp  , average );
        wait(1);
    }
}

//int main(void)
//{
//    Tune(Buzzer, C_4, 4);  //4 Octave C beat 4/16
//    wait_ms(250);
//    Tune(Buzzer, D_4, 4);  //4 Octave D beat 4/16
//    wait_ms(250);
//    Tune(Buzzer, E_4, 4);  //4 Octave E beat 4/16
//    wait_ms(250);
//
//    int i;
//
//    for(i=0; i<tones_num; i++) {
//        Auto_tunes(Buzzer, tones[i], 4); // Auto performance
//        Stop_tunes(Buzzer);
//    }
//
//}





