//GPS GT-720F Logger01
//program detail : http://www.oidenansho.com/elekijack/mbed/2bk0208_GPS_logger/GPS_logger.htm

#include "mbed.h"
#include <list>

#define ON 1
#define OFF 0

typedef struct {
    int jst[3];
    float tokei;
    float hokui;
} POINT;

DigitalOut mled0(LED1);
DigitalOut mled1(LED2);
//DigitalIn sw1(p5);
InterruptIn sw(p5);

//Textpc pc(p24, p25, p26, p27, p28, p29, p30,20,4); // rs, rw, e, d0, d1, d2, d3
Serial pc(USBTX,USBRX);
Serial gps(p28,p27);
//LocalFileSystem local("local");
Ticker flipper;
FILE *fp;
float g_hokui,g_tokei;
int fp_count=0;
int h_time=0,m_time=0,s_time=0;
typedef std::list<POINT> LP;    //構造体POINTのlistの型宣言
LP points;  //時刻と座標データのバッファ

void irq()  //バッファからの読み出し，バッファが空になるまでteratermに表示させる
{
    for(LP::iterator itr = points.begin(); !points.empty();) {
        pc.printf("%02d:%02d:%02d,%f,%f\n",itr->jst[0],itr->jst[1],itr->jst[2],itr->tokei,itr->hokui);
        itr = points.erase(itr);
    }
}

void gps_rec()  //バッファにデータを格納する．Tickerで割り込まれているので，サンプル時間は任意に調整可能．現在5[s]置きでも受信可能
{
    static POINT p = {{0,0,0},0,0};
    mled0=ON;
    p.jst[0]=h_time;
    p.jst[1]=m_time;
    p.jst[2]=s_time;
    p.tokei = g_tokei;
    p.hokui = g_hokui;
//  pc.printf("%4.6f,%3.6f,\n",g_tokei,g_hokui);
    points.push_back(p);
    wait(1.0);
    mled0=OFF;
    fp_count++;
}

int main()
{
    sw.rise(&irq);
    char c;
    int i,rlock=0,stn=0;
    char gps_data[256];
    char ns,ew;
    float time,hokui,tokei;

    float d_hokui,m_hokui,d_tokei,m_tokei;
    int rec_flag=0;

    gps.baud(9600);
    pc.printf("*** GPS GT-720F ****\n");
    pc.printf("File open...\n");
    wait(1.0);
//      fp=fopen("/local/GPS.txt","a");
    pc.printf("System start...\n");
    pc.printf("Loging ready ok...\n");
    pc.printf("\n");
    wait(1.0);

    while (1) {
        i=0;
        while(gps.getc()!='$') {
        }

        while( (gps_data[i]=gps.getc()) != '\r') {
            i++;
            if(i==256) {
                pc.printf("*** Data read  Error! ***\n");
                i=255;
                break;
            }
        }
        gps_data[i]='\0';

        //test
        /* Test data
         rlock=1;
         stn=3;
         hokui=3532.25024; //=>35.537502
         tokei=13751.86820;//=>137.864471
         time=114107.046;
        */
        if( sscanf(gps_data, "GPGGA,%f,%f,%c,%f,%c,%d,%d",&time,&hokui,&ns,&tokei,&ew,&rlock,&stn) >= 1) {
            if(rlock >= 1) {

                //hokui
                d_hokui=int(hokui/100);
                m_hokui=(hokui-d_hokui*100)/60;
                g_hokui=d_hokui+m_hokui;
                //tokei
                d_tokei=int(tokei/100);
                m_tokei=(tokei-d_tokei*100)/60;
                g_tokei=d_tokei+m_tokei;
                //g_hokui=int(hokui/100)+(hokui-int(hokui/100))/60;
                //g_tokei=int(tokei/100)+(tokei-int(tokei/100))/60;

                //time set
                h_time=int(time/10000);
                m_time=int((time-h_time*10000)/100);
                s_time=int(time-h_time*10000-m_time*100);
                h_time=h_time+9;//UTC =>JST

                // Record start
                if(rec_flag==0) {
                    flipper.attach(&gps_rec, 5.0);
                    rec_flag=1;
                    pc.printf("JST %2d:%2d:%2d\n",h_time,m_time,s_time);
                    mled0=ON;
                    pc.printf("Loging start....");
                    wait(5.0);
                    mled0=ON;
                }

                pc.printf("*GPS JST %2d:%2d:%2d,",h_time,m_time,s_time);
                pc.printf("Lk(%d),St(%d),%d,",rlock,stn,fp_count);
                //Latitude=Hokui
                pc.printf("Lat/d:%4.6f,",g_hokui);
                // Logitude=tokei
                pc.printf("Log/d:%4.6f\n",g_tokei);
            } else {
                flipper.detach();
                rec_flag=0;
                pc.printf("*** GPS GT-720F ***");
                pc.printf("Lk(%d),St(%d)\n",rlock,stn);
                /*          for(i=0;i<40;i++){
                            pc.printf("%c",gps_data[i]);
                          }*/
            }
        }//if
    }//while
}//main