#include "mbed.h"


//---------------------------------------
// Definitions
//---------------------------------------
#define UART_BUFFER_LENGTH      512
#define UART_RX_TIMEOUT_US      1000
#define UART_BAUDRATE           115200
#define UART_BITS               8
#define UART_STOPBIT            1

//---------------------------------------
// Enums
//---------------------------------------
typedef enum {
    UART_MODE_LISTEN,
    UART_MODE_RX_READY,
    //-----------------
    CNT_eUART_mode
} eUART_mode;


//---------------------------------------
// Structures
//---------------------------------------
typedef struct {
    eUART_mode mode;            // mode of UART hardware
    char *ptrBuffer;            // start address of buffer
    char *ptrReadPositon;       // actual read position in buffer
    char *ptrWritePosition;     // actual write position in buffer
    char bytesToRead;           // Number of received bytes
    char bytesToWrite;          // Number of bytes to send
} sUART_handler;



//---------------------------------------
// Global Variables
//---------------------------------------
extern sUART_handler UART_handler;
extern char uartBuffer[UART_BUFFER_LENGTH];


//---------------------------------------
// Global Functions
//---------------------------------------
void UART_init( void );
void UART_reset( void );            // clear all UART registers, --> restart
int UART_newFrame( void );          // check for new received frame
int UART_checkReceivedCRC( void );  // check received CRC16
int UART_sendData( void );          // send data saved in buffer