#include "mbed.h"



//---------------------------------------
// Definitions
//---------------------------------------
#define RS232_BUFFER_LENGTH      256
#define RS232_RX_TIMEOUT_US      50000
#define RS232_BAUDRATE           9600
#define RS232_BITS               8
#define RS232_STOPBIT            1


//---------------------------------------
// Enums
//---------------------------------------
typedef enum
{
    RS232_MODE_LISTEN,
    RS232_MODE_RX_READY,
    //-----------------
    CNT_eRS232_mode
}eRS232_mode;



//---------------------------------------
// Structures
//---------------------------------------
typedef struct
{
    eRS232_mode mode;           // mode of RS232 hardware
    char *ptrReadPositon;       // actual read position in buffer
    int   bytesToRead;          // Number of received bytes
}sRS232_handler;



//---------------------------------------
// Global Variables
//---------------------------------------



//---------------------------------------
// Global Functions
//---------------------------------------
void RS232_init( void );                                 // Init hardware and internal buffer


int RS232_receiveData( char *& ptrData, int *ptrNumBytes );     // "char *&" = reference to pointer !!
                                                                // return pointer to buffer and number of received bytes
                                                                // Return 1: New data available, get pointer to buffer and number of bytes to read
                                                                // Return 0: No new data available
int RS232_sendData( char *ptrData, int NumBytes );      // send data NumBytes bytes from source pointer: ptrData
                                                            // Return 1: Sending was successfull
                                                            // Return 0: Could not send data, eithter to many bytes, zero bytes or UART is still listining

void RS232_setRTS( int level);
int RS232_getCTS( void );