#include "mbed.h"
#include "uart.h"
#include "interpret.h"
#include "pt100.h"
#include "MCP23017.h"



//---------------------------------------
// Hardware recources
//---------------------------------------
MCP23017 *PT100_I2C;



//---------------------------------------
// Prototypes
//---------------------------------------
unsigned char PT100_mirrowBits( unsigned char input);



//---------------------------------------
// Internal variables
//---------------------------------------




//---------------------------------------
// External variables
//---------------------------------------



//---------------------------------------
// Global Functions
//---------------------------------------
void PT100_init( void )
{
    PT100_I2C = new MCP23017( p9, p10, PT100_I2C_ADD);
    PT100_I2C->config(0,0,0);           // set to outputs, no pull-ups, not-inverted
    PT100_I2C->write_mask(0, 0xFFFF);   // set outputs low
}



// process commands
void PT100_deviceID_process( void )
{
    unsigned short temp16U;
    
    switch( uartBuffer[ INT_BUF_COMMAND ] )
    {
        //-----------------
        case PT100_COM_SET:
        //-----------------
        {
            // Get byte
            temp16U = (unsigned short)PT100_mirrowBits( uartBuffer[ INT_BUF_1DATA ]);
            // Write to PT100 HW
            PT100_I2C->write_mask(temp16U, 0x00FF);
            // Generate acknowledge
            INT_generateACKFrame(INT_ID_PT100, INT_COM_ACK);

            break;
        }
        
        //-----------------
        case PT100_COM_GET:
        //-----------------
        {
            temp16U = (unsigned short)PT100_mirrowBits( (unsigned char)(PT100_I2C->read_mask(0x00FF)));
            
            // Generate acknowledge
            uartBuffer[INT_BUF_DEVICEID] = INT_ID_PT100;
            uartBuffer[INT_BUF_COMMAND] = INT_COM_ACK;
            uartBuffer[INT_BUF_NUM] = 1;
            uartBuffer[INT_BUF_1DATA] = (char)(0x00FF & temp16U);
            UART_handler.bytesToWrite = 4;
        
            break;
        }   
        
        //-----------------
        default:
        //-----------------
        {
            // Command not supported
            INT_generateACKFrame(INT_ID_PT100, INT_COM_COM_NOTSUPP);
        }     
    }//switch
    
}

//---------------------------------------
// Internal Functions
//---------------------------------------

unsigned char PT100_mirrowBits( unsigned char input)
{
    char i;
    unsigned char tempChar = 0;
    
    for( i = 0; i < 8; i++)
    {
        if( input & (1 << i) )
        {
            tempChar |= (1 << 7 - i);
        }
    
    }
    
    return tempChar;
}
