#include "mbed.h"



//---------------------------------------
// Definitions
//---------------------------------------


//---------------------------------------
// Enums
//---------------------------------------




// Global commands 0 - 20 are defined in interpret.h
// Commands 21 - 127 are HW-unit commands
typedef enum
{
    MBED_SET_RPM_LEVEL_LOW = 21,    // 21: setRPMLevelLow
    MBED_SET_RPM_LEVEL_HIGH,        // 22: setRPMLevelLow
    MBED_SET_PWM_PORT,              // 23: setPWMPort
    MBED_SET_PWM_FREQ,              // 24: setPWMFreq
    MBED_SET_PWM_DC,                // 25: setPWMDutyCycle
    MBED_WRITE_RS232,               // 26: writeRS232
    MBED_READ_RS232,                // 27: readRS232
    MBED_SET_RTSRS232,              // 28: setRTSRS232
    MBED_GET_CTSRS232,              // 29: getCTSRS232
    MBED_WRITE_CAN,                 // 30: writeCAN
    MBED_READ_CAN,                  // 31: readCAN
    MBED_READ_ADC,                  // 32: readADC
    MBED_SET_RELAY,                 // 33: setRelay
    MBED_SET_DO1,                   // 34: setDO1
    MBED_SET_DO2,                   // 35: setDO2
    MBED_GET_DI,                    // 36: getDI
    MBED_WRITE_RS485,               // 37: writeRS485
    MBED_READ_RS485,                // 38: readRS485
    //----------------
    CNT_eMBED_command
}eMBED_command;



//---------------------------------------
// Structures
//---------------------------------------



//---------------------------------------
// Global Variables
//---------------------------------------



//---------------------------------------
// Global Functions
//---------------------------------------
void MBED_init( void );
void MBED_deviceID_process( void );
