#include "mbed.h"


//---------------------------------------
// Definitions
//---------------------------------------
#define INT_BUF_DEVICEID    0   // UART buffer index of DeviceID
#define INT_BUF_COMMAND     1   // UART buffer index of Command
#define INT_BUF_NUM         2   // UART buffer index of number of Bytes
#define INT_BUF_1DATA       3   // UART buffer index of first data byte if #Bytes > 0



//---------------------------------------
// Enums
//---------------------------------------
typedef enum
{
    INT_STATE_INIT,
    INT_STATE_IDLE,
    INT_STATE_CHECK,
    INT_STATE_INTERPRET,
    INT_STATE_ACK,
    //---------------
    CNT_eINT_state
}eINT_state;



typedef enum
{
    INT_ID_BROADCAST = 0,
    INT_ID_MBED,
    INT_ID_PT100,
    INT_ID_DI,
    INT_ID_DO,
    //----------------------
    CNT_eINT_deviceID

}eINT_deviceID;


// Global commands 0 - 20,
// Commands 21 - 127 are devined inside the individual HW-units
typedef enum
{
    INT_COM_NOP = 0,        // 0: NOP
    INT_COM_RESET,          // 1: Reset
    INT_COM_ACK,            // 2: ACK
    INT_COM_DEV_NOTSUPP,    // 3: DeviceID not supported
    INT_COM_COM_NOTSUPP,    // 4: Command not supported          
    INT_COM_VAL_NOTVALID,   // 5: Value is not valid
    INT_COM_6,
    INT_COM_7,
    INT_COM_8,
    INT_COM_9,
    INT_COM_10,
    INT_COM_11,
    INT_COM_12,
    INT_COM_13,
    INT_COM_14,
    INT_COM_15,
    INT_COM_16,
    INT_COM_17,
    INT_COM_18,
    INT_COM_19,
    INT_COM_20,
    //----------------
    CNT_eINT_command
}eINT_command;


//---------------------------------------
// Structures
//---------------------------------------
typedef struct
{
   eINT_state state; 
   char receivedDeviceID;
   char receivedCommand;

}sINT_handler;



//---------------------------------------
// Global Variables
//---------------------------------------


//---------------------------------------
// Global Functions
//---------------------------------------
void INT_init( void );
void INT_poll( void );
void INT_generateACKFrame(char deviceID, char command);
