#include "mbed.h"



//---------------------------------------
// Definitions
//---------------------------------------
#define DO_I2C_ADD      ( I2C_BASE_ADDRESS | (7 << 1) )    // I2C_BASE_ADDRESS is defined in MCP23017
#define DO_NUMBER_PINS  ( 16 )


//---------------------------------------
// Enums
//---------------------------------------

// define pin number (0..15) of MCP23017
typedef enum
{
    DO_PIN1 = 15,      
    DO_PIN2 = 14,     
    DO_PIN3 = 13,   
    DO_PIN4 = 12,   
    DO_PIN5 = 11,   
    DO_PIN6 = 10,   
    DO_PIN7 = 9, 
    DO_PIN8 = 8,   
    DO_PIN9 = 7,   
    DO_PIN10 = 6,  
    DO_PIN11 = 5,   
    DO_PIN12 = 4,   
    DO_PIN13 = 3,  
    DO_PIN14 = 2,   
    DO_PIN15 = 1,  
    DO_PIN16 = 0
}DO_ePinTable;


// Global commands 0 - 20 are defined in interpret.h
// Commands 21 - 127 are HW-unit commands
typedef enum
{
    DO_GET_SINGLE = 21,     // 21: getSingle
    DO_GET_PORT,            // 22: getPort
    //----------------
    CNT_eDO_command
}eDO_command;



//---------------------------------------
// Structures
//---------------------------------------



//---------------------------------------
// Global Variables
//---------------------------------------



//---------------------------------------
// Global Functions
//---------------------------------------
void DO_init( void );
void DO_deviceID_process( void );
